/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.webclients.openmrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bahmni.webclients.WebClientsException;
import org.bahmni.webclients.openmrs.OpenMRSAuthenticationResponse;

public class OpenMRSAuthenticator {
    private static Logger logger = LogManager.getLogger(OpenMRSAuthenticator.class);
    private String authURL;
    private int connectionTimeout;
    private int readTimeout;

    public OpenMRSAuthenticator(String authURL, int connectionTimeout, int readTimeout) {
        this.authURL = authURL;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    public OpenMRSAuthenticationResponse authenticate(String user, String password, ObjectMapper objectMapper) {
        String responseText = null;
        HttpGet httpGet = new HttpGet(this.authURL);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectionTimeout).setSocketTimeout(this.readTimeout).setConnectionRequestTimeout(this.readTimeout).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        try {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, password);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            HttpClientContext context = HttpClientContext.create();
            context.setCookieStore((CookieStore)new BasicCookieStore());
            context.setCredentialsProvider((CredentialsProvider)credsProvider);
            Header authorizationHeader = new BasicScheme(StandardCharsets.UTF_8).authenticate((Credentials)credentials, (HttpRequest)httpGet, (HttpContext)context);
            httpGet.setHeader(authorizationHeader);
            logger.info(String.format("Executing request: %s", httpGet.getRequestLine()));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                InputStream content = entity.getContent();
                responseText = IOUtils.toString((InputStream)content);
            }
            logger.info("OMRS Authentication successful");
            logger.debug(String.format("Authentication response: %s", responseText));
            EntityUtils.consume((HttpEntity)entity);
            OpenMRSAuthenticationResponse openMRSAuthenticationResponse = (OpenMRSAuthenticationResponse)objectMapper.readValue(responseText, OpenMRSAuthenticationResponse.class);
            return openMRSAuthenticationResponse;
        }
        catch (Exception e) {
            throw new WebClientsException(e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }
}

