/*
 * Decompiled with CFR 0.152.
 */
package org.bahmni.webclients.openmrs;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bahmni.webclients.Authenticator;
import org.bahmni.webclients.ClientCookies;
import org.bahmni.webclients.ConnectionDetails;
import org.bahmni.webclients.HttpHeaders;
import org.bahmni.webclients.HttpRequestDetails;
import org.bahmni.webclients.WebClientsException;
import org.bahmni.webclients.openmrs.OpenMRSAuthenticationResponse;

public class OpenMRSLoginAuthenticator
implements Authenticator {
    private static Logger logger = LogManager.getLogger(OpenMRSLoginAuthenticator.class);
    private final String SESSION_ID_KEY = "JSESSIONID";
    private ConnectionDetails authenticationDetails;
    private HttpRequestDetails previousSuccessfulRequest;

    public OpenMRSLoginAuthenticator(ConnectionDetails authenticationDetails) {
        this.authenticationDetails = authenticationDetails;
    }

    @Override
    public HttpRequestDetails getRequestDetails(URI uri) {
        if (this.previousSuccessfulRequest == null) {
            return this.refreshRequestDetails(uri);
        }
        return this.previousSuccessfulRequest.createNewWith(uri);
    }

    @Override
    public HttpRequestDetails refreshRequestDetails(URI uri) {
        String responseText = null;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.authenticationDetails.getConnectionTimeout()).setSocketTimeout(this.authenticationDetails.getReadTimeout()).setConnectionRequestTimeout(this.authenticationDetails.getReadTimeout()).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
        HttpGet httpGet = new HttpGet(this.authenticationDetails.getAuthUrl());
        try {
            this.setCredentials(httpGet);
            logger.info(String.format("Executing request: %s", httpGet.getRequestLine()));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() == 204) {
                throw new WebClientsException("Two factor authentication is enabled, Please enable required privilege for the user");
            }
            if (entity != null) {
                InputStream content = entity.getContent();
                responseText = IOUtils.toString((InputStream)content);
            }
            logger.info(String.format("Authentication response: %s", responseText));
            EntityUtils.consume((HttpEntity)entity);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            OpenMRSAuthenticationResponse openMRSResponse = (OpenMRSAuthenticationResponse)objectMapper.readValue(responseText, OpenMRSAuthenticationResponse.class);
            this.confirmAuthenticated(openMRSResponse);
            ClientCookies clientCookies = new ClientCookies();
            clientCookies.put("JSESSIONID", this.ExtractStringUsingRegex(response.getHeaders("Set-Cookie")[0].getValue()));
            HttpRequestDetails httpRequestDetails = this.previousSuccessfulRequest = new HttpRequestDetails(uri, clientCookies, new HttpHeaders());
            return httpRequestDetails;
        }
        catch (Exception e) {
            throw new WebClientsException(e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String ExtractStringUsingRegex(String Cookie2) {
        if (Cookie2 == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("\\bJSESSIONID=([A-Z0-9]{32})");
        Matcher matcher = pattern.matcher(Cookie2);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new WebClientsException("No Matching SessionID in the Response Cookie");
    }

    protected void setCredentials(HttpGet httpGet) throws AuthenticationException {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.authenticationDetails.getUserId(), this.authenticationDetails.getPassword());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)new BasicCookieStore());
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        Header authorizationHeader = new BasicScheme(StandardCharsets.UTF_8).authenticate((Credentials)credentials, (HttpRequest)httpGet, (HttpContext)context);
        httpGet.setHeader(authorizationHeader);
    }

    private void confirmAuthenticated(OpenMRSAuthenticationResponse openMRSResponse) {
        if (!openMRSResponse.isAuthenticated()) {
            logger.error("Could not authenticate with OpenMRS. ");
            throw new WebClientsException("Could not authenticate with OpenMRS");
        }
    }
}

