/*
 * Decompiled with CFR 0.152.
 */
package org.bakeneko.rabbitmq.rpc.context;

import java.util.regex.Pattern;
import org.bakeneko.rabbitmq.rpc.context.PropertyReferenceResolver;
import org.springframework.core.env.Environment;
import org.springframework.util.PropertyPlaceholderHelper;

public class PropertyReferenceResolverImpl
implements PropertyReferenceResolver {
    private Environment environment;
    private PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("${", "}", ":", true);
    private Pattern propertyReferencePattern = Pattern.compile("^\\$\\{.*}$");

    public PropertyReferenceResolverImpl(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String replaceIfProperty(String value) {
        if (value != null && !value.isEmpty() && this.propertyReferencePattern.matcher(value).matches()) {
            return this.propertyPlaceholderHelper.replacePlaceholders(value, name -> this.environment.getRequiredProperty(name));
        }
        return value;
    }
}

