/*
 * Decompiled with CFR 0.152.
 */
package org.bakeneko.rabbitmq.rpc.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bakeneko.rabbitmq.rpc.RabbitClient;
import org.bakeneko.rabbitmq.rpc.RabbitSender;
import org.bakeneko.rabbitmq.rpc.context.ContextSupport;
import org.bakeneko.rabbitmq.rpc.context.PropertyReferenceResolver;
import org.bakeneko.rabbitmq.rpc.factory.RabbitClientAnnotationProcessor;
import org.bakeneko.rabbitmq.rpc.factory.RabbitClientMetadata;
import org.bakeneko.rabbitmq.rpc.factory.ReflectionUtils;
import org.bakeneko.rabbitmq.rpc.generator.ExchangeGenerator;
import org.bakeneko.rabbitmq.rpc.generator.RoutingKeyGenerator;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;

public class RabbitClientAnnotationProcessorImpl
implements RabbitClientAnnotationProcessor {
    private PropertyReferenceResolver propertyReferenceResolver;
    private ContextSupport contextSupport;

    public RabbitClientAnnotationProcessorImpl(PropertyReferenceResolver propertyReferenceResolver, ContextSupport contextSupport) {
        this.propertyReferenceResolver = propertyReferenceResolver;
        this.contextSupport = contextSupport;
    }

    @Override
    public Map<String, RabbitClientMetadata> readMetadata(Class<?> toImplement) {
        if (toImplement.isAnnotationPresent(RabbitClient.class)) {
            RabbitClient rabbitClient = toImplement.getAnnotation(RabbitClient.class);
            ExchangeGenerator defaultExchangeGenerator = this.getExchangeGenerator(rabbitClient);
            RoutingKeyGenerator defaultRoutingKeyGenerator = this.getRoutingKeyGenerator(rabbitClient);
            MessagePostProcessor defaultMessagePostProcessor = this.getMessagePostProcessor(rabbitClient.messagePostProcessor());
            Map<String, Method> methodsByName = Stream.of(toImplement.getDeclaredMethods()).collect(Collectors.toMap(ReflectionUtils::methodNameSignatureAware, m -> m));
            return methodsByName.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                Method method = (Method)entry.getValue();
                Integer payloadParameterIndex = this.getPayloadParameterIndex(method);
                Integer headerMapParameterIndex = this.getHeaderMapParameterIndex(method);
                Map<String, Integer> headerParameterIndexByName = this.getHeaderParameterIndexByName(method);
                if (method.isAnnotationPresent(RabbitSender.class)) {
                    RabbitSender rabbitSender = method.getAnnotation(RabbitSender.class);
                    ExchangeGenerator exchangeGenerator = this.getExchangeGenerator(rabbitSender);
                    RoutingKeyGenerator routingKeyGenerator = this.getRoutingKeyGenerator(rabbitSender);
                    MessagePostProcessor messagePostProcessor = this.getMessagePostProcessor(rabbitSender.messagePostProcessor());
                    return new RabbitClientMetadata(exchangeGenerator != null ? exchangeGenerator : defaultExchangeGenerator, routingKeyGenerator != null ? routingKeyGenerator : defaultRoutingKeyGenerator, messagePostProcessor != null ? messagePostProcessor : defaultMessagePostProcessor, payloadParameterIndex, headerMapParameterIndex, headerParameterIndexByName);
                }
                return new RabbitClientMetadata(defaultExchangeGenerator, defaultRoutingKeyGenerator, defaultMessagePostProcessor, payloadParameterIndex, headerMapParameterIndex, headerParameterIndexByName);
            }));
        }
        throw new IllegalArgumentException("The class provided is not a @RabbitClient: " + toImplement.getCanonicalName());
    }

    private Integer getPayloadParameterIndex(Method method) {
        if (method.getParameterCount() == 1 && !this.isHeader(method.getParameters()[0])) {
            return 0;
        }
        if (method.getParameterCount() == 0 || method.getParameterCount() == 1 && this.isHeader(method.getParameters()[0])) {
            throw new IllegalStateException(String.format("No @Payload parameters found in %s.%s. At least one @Payload parameter must be present - if a parameter is the only one and not marked as @Header, it's also considered @Payload.", method.getDeclaringClass().getName(), method.getName()));
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            if (!this.isPayload(method.getParameters()[i])) continue;
            return i;
        }
        throw new IllegalStateException(String.format("Multiple parameters specified in %s.%s, but none of them is marked as @Payload.", method.getDeclaringClass().getName(), method.getName()));
    }

    private Map<String, Integer> getHeaderParameterIndexByName(Method method) {
        HashMap<String, Integer> indexByName = new HashMap<String, Integer>();
        AtomicInteger i = new AtomicInteger(0);
        while (i.get() < method.getParameterCount()) {
            Stream.of(method.getParameterAnnotations()[i.get()]).filter(it -> it.annotationType().equals(Header.class)).findFirst().ifPresent(annotation -> {
                Header header = (Header)annotation;
                String headerName = !header.value().isEmpty() ? header.value() : (!header.name().isEmpty() ? header.name() : method.getParameters()[i.get()].getName());
                indexByName.put(headerName, i.get());
            });
            i.incrementAndGet();
        }
        return indexByName;
    }

    private Integer getHeaderMapParameterIndex(Method method) {
        long headerMapParameters = Stream.of(method.getParameters()).filter(this::isHeaderMap).count();
        if (headerMapParameters == 1L) {
            for (int i = 0; i < method.getParameterCount(); ++i) {
                if (!this.isHeaderMap(method.getParameters()[i])) continue;
                Class<?> parameterType = method.getParameters()[i].getType();
                if (Map.class.isAssignableFrom(parameterType)) {
                    return i;
                }
                throw new IllegalArgumentException(String.format("Parameters marked as @Headers must be assignable to java.util.Map<String, Object>, while %s.%s has type %s.", method.getDeclaringClass().getName(), method.getName(), parameterType));
            }
        } else if (headerMapParameters > 1L) {
            throw new IllegalStateException(String.format("Multiple @Headers parameters specified in %s.%s, while a maximum of 1 is allowed.", method.getDeclaringClass().getName(), method.getName()));
        }
        return null;
    }

    private boolean isHeader(Parameter parameter) {
        return this.hasAnnotation(parameter, Header.class);
    }

    private boolean isHeaderMap(Parameter parameter) {
        return this.hasAnnotation(parameter, Headers.class);
    }

    private boolean isPayload(Parameter parameter) {
        return this.hasAnnotation(parameter, Payload.class);
    }

    private <T extends Annotation> boolean hasAnnotation(Parameter parameter, Class<T> annotationType) {
        return Stream.of(parameter.getAnnotations()).anyMatch(it -> it.annotationType().equals(annotationType));
    }

    private MessagePostProcessor getMessagePostProcessor(String beanName) {
        if (!beanName.isEmpty()) {
            return this.getRequiredBean(beanName, MessagePostProcessor.class);
        }
        return null;
    }

    private ExchangeGenerator getExchangeGenerator(RabbitClient rabbitClient) {
        return this.getExchangeGenerator(rabbitClient.exchange(), rabbitClient.exchangeGenerator());
    }

    private ExchangeGenerator getExchangeGenerator(RabbitSender rabbitSender) {
        return this.getExchangeGenerator(rabbitSender.exchange(), rabbitSender.exchangeGenerator());
    }

    private ExchangeGenerator getExchangeGenerator(String exchange, String exchangeGenerator) {
        if (!exchange.isEmpty() && !exchangeGenerator.isEmpty()) {
            throw new IllegalStateException("Both 'exchange' and 'exchangeGenerator' specified in @RabbitClient, although they are mutually exclusive.");
        }
        if (!exchange.isEmpty()) {
            String hardCodedExchange = this.propertyReferenceResolver.replaceIfProperty(exchange);
            return (target, method, params) -> hardCodedExchange;
        }
        if (!exchangeGenerator.isEmpty()) {
            return this.getRequiredBean(exchangeGenerator, ExchangeGenerator.class);
        }
        return null;
    }

    private RoutingKeyGenerator getRoutingKeyGenerator(RabbitClient rabbitClient) {
        return this.getRoutingKeyGenerator(rabbitClient.routingKey(), rabbitClient.routingKeyGenerator());
    }

    private RoutingKeyGenerator getRoutingKeyGenerator(RabbitSender rabbitSender) {
        return this.getRoutingKeyGenerator(rabbitSender.routingKey(), rabbitSender.routingKeyGenerator());
    }

    private RoutingKeyGenerator getRoutingKeyGenerator(String routingKey, String routingKeyGenerator) {
        if (!routingKey.isEmpty() && !routingKeyGenerator.isEmpty()) {
            throw new IllegalStateException("Both 'routingKey' and 'routingKeyGenerator' specified in @RabbitClient, although they are mutually exclusive.");
        }
        if (!routingKey.isEmpty()) {
            String hardCodedRoutingKey = this.propertyReferenceResolver.replaceIfProperty(routingKey);
            return (target, method, params) -> hardCodedRoutingKey;
        }
        if (!routingKeyGenerator.isEmpty()) {
            return this.getRequiredBean(routingKeyGenerator, RoutingKeyGenerator.class);
        }
        return null;
    }

    private <T> T getRequiredBean(String beanName, Class<T> beanType) {
        try {
            return this.contextSupport.getBean(beanName, beanType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Required bean with name \"" + beanName + "\" could not be found, although it is required by a @RabbitClient", e);
        }
    }
}

