/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.apm.elastic;

import co.elastic.apm.attach.ElasticApmAttacher;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="bard.apm.elastic")
public class ElasticApmConfiguration {
    private String enabled;
    private Map<String, String> elastic;

    @ConditionalOnProperty(name={"bard.apm.elastic.enabled"}, havingValue="true")
    @PostConstruct
    void init() {
        if (!"true".equals(this.enabled)) {
            return;
        }
        this.elastic.remove("enabled");
        this.elastic.put("activation_method", "PROGRAMMATIC_SELF_ATTACH");
        ElasticApmAttacher.attach(this.elastic);
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public void setElastic(Map<String, String> elastic) {
        this.elastic = elastic;
    }
}

