/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.captcha;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.captcha.CaptchaType;
import org.bardframework.commons.captcha.CaptchaTypeInfo;
import org.bardframework.commons.captcha.GeneratedCaptcha;
import org.bardframework.commons.utils.persian.LetterConverterUtility;

public class CaptchaService {
    private final Random random = new Random();
    private Map<CaptchaType, CaptchaTypeInfo> captchaTypeInfoMap = new ConcurrentHashMap<CaptchaType, CaptchaTypeInfo>();

    public CaptchaService() {
        this.captchaTypeInfoMap.put(CaptchaType.PERSIAN_NUMBER_TEXT, new CaptchaTypeInfo("0123456789", false, new Font("Tahoma", 0, 40)));
        this.captchaTypeInfoMap.put(CaptchaType.ENGLISH_NUMBER, new CaptchaTypeInfo("0123456789", false, new Font("Tahoma", 0, 40)));
        this.captchaTypeInfoMap.put(CaptchaType.PERSIAN_CHAR, new CaptchaTypeInfo("\u0628\u062a\u062c\u062d\u062e\u062f\u0631\u0698\u0633\u0634\u0636\u0638\u0639\u0641\u0642\u06a9\u0644\u0645\u0646\u0648\u0647\u06cc", true, new Font("Tahoma", 0, 40)));
        this.captchaTypeInfoMap.put(CaptchaType.PERSIAN_NUMBER_CHAR, new CaptchaTypeInfo("0123456789\u0628\u062a\u062c\u062d\u062e\u062f\u0631\u0698\u0633\u0634\u0636\u0638\u0639\u0641\u0642\u06a9\u0644\u0645\u0646\u0648\u0647\u06cc", true, new Font("Tahoma", 0, 40)));
        this.captchaTypeInfoMap.put(CaptchaType.ARABIC_CHAR, new CaptchaTypeInfo("\u0627\u0628\u062a\u062b\u062c\u062d\u062e\u062f\u0630\u0631\u0632\u0633\u0634\u0635\u0636\u0637\u0638\u0641\u0642\u0639\u063a\u06a9\u0644\u0645\u0646\u0648\u0647\u06cc", true, new Font("Tahoma", 0, 40)));
        this.captchaTypeInfoMap.put(CaptchaType.ARABIC_NUMBER_CHAR, new CaptchaTypeInfo("0123456789\u0627\u0628\u062a\u062b\u062c\u062d\u062e\u062f\u0630\u0631\u0632\u0633\u0634\u0635\u0636\u0637\u0638\u0641\u0642\u0639\u063a\u06a9\u0644\u0645\u0646\u0648\u0647\u06cc", true, new Font("Tahoma", 0, 40)));
        this.captchaTypeInfoMap.put(CaptchaType.ENGLISH_CHAR, new CaptchaTypeInfo("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", false, new Font("Tahoma", 0, 40)));
        this.captchaTypeInfoMap.put(CaptchaType.ENGLISH_NUMBER_CHAR, new CaptchaTypeInfo("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz", false, new Font("Tahoma", 0, 40)));
    }

    public GeneratedCaptcha generateCaptcha(CaptchaType type, int maxChars) {
        CaptchaTypeInfo captchaTypeInfo = this.getCaptchaTypeInfoMap().get((Object)type);
        if (null == captchaTypeInfo) {
            throw new IllegalStateException(String.format("no chars specify for type %s to generate captcha", new Object[]{type}));
        }
        StringBuilder captchaText = StringUtils.isNumeric((CharSequence)captchaTypeInfo.getChars()) ? new StringBuilder(RandomStringUtils.random((int)maxChars, (String)captchaTypeInfo.getChars())) : this.removeContinuousNumbers(RandomStringUtils.random((int)maxChars, (String)captchaTypeInfo.getChars()), captchaTypeInfo.getChars());
        String text = captchaText.toString();
        String textForImage = type == CaptchaType.PERSIAN_NUMBER_TEXT ? LetterConverterUtility.convertDigitToFarsiLetter((long)Long.valueOf(text)) : (captchaTypeInfo.isRtl() ? captchaText.reverse().toString() : captchaText.toString());
        return new GeneratedCaptcha(text, this.generateImage(type, textForImage, captchaTypeInfo.getFont()));
    }

    private byte[] generateImage(CaptchaType type, String text, Font font) {
        byte[] byArray;
        int i;
        int height = 40;
        int width = Math.min(text.length() * height, 400);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setColor(new Color(RandomUtils.nextInt((int)170, (int)255), RandomUtils.nextInt((int)180, (int)255), RandomUtils.nextInt((int)200, (int)255)));
        graphics.fillRect(0, 0, width, height);
        graphics.setFont(font);
        graphics.setColor(this.getRandomColor());
        int start = 30;
        if (type != CaptchaType.PERSIAN_NUMBER_TEXT) {
            for (i = 0; i < text.length(); ++i) {
                graphics.drawString(text.substring(i, i + 1), start + i * 20, this.random.nextInt(15) + 25);
            }
        } else {
            String[] parts = text.split(" ");
            int j = 0;
            for (int i2 = parts.length - 1; i2 >= 0; --i2) {
                graphics.drawString(parts[i2], start + parts[i2].length() + j * 82, this.random.nextInt(15) + 25);
                ++j;
            }
        }
        for (i = 0; i < text.length() - 2; ++i) {
            graphics.drawOval(this.random.nextInt(width), this.random.nextInt(height), this.random.nextInt(500), this.random.nextInt(100));
        }
        graphics.dispose();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    private StringBuilder removeContinuousNumbers(String text, String validChars) {
        StringBuilder result = new StringBuilder();
        boolean previousNumber = false;
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isDigit(text.charAt(i)) && (i == 0 || i == text.length() - 1 || previousNumber)) {
                String notDigit = RandomStringUtils.random((int)1, (String)validChars);
                while (Character.isDigit(notDigit.charAt(0))) {
                    notDigit = RandomStringUtils.random((int)1, (String)validChars);
                }
                result.append(notDigit);
                previousNumber = false;
                continue;
            }
            result.append(text.charAt(i));
            previousNumber = Character.isDigit(text.charAt(i));
        }
        return result;
    }

    private Color getRandomColor() {
        return new Color(this.random.nextInt(255), this.random.nextInt(255), this.random.nextInt(255));
    }

    public Map<CaptchaType, CaptchaTypeInfo> getCaptchaTypeInfoMap() {
        return this.captchaTypeInfoMap;
    }

    public void setCaptchaTypeInfoMap(Map<CaptchaType, CaptchaTypeInfo> captchaTypeInfoMap) {
        this.captchaTypeInfoMap = captchaTypeInfoMap;
    }
}

