/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bardframework.commons.config.ConfigKey;
import org.bardframework.commons.config.ResourceUtils;
import org.bardframework.commons.reflection.ReflectionUtils;
import org.bardframework.commons.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;

public class ReloadableConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadableConfig.class);
    private static Properties config = new Properties();
    private final List<String> reloadableConfigPath;

    public ReloadableConfig(List<String> reloadableConfigPath) throws IOException {
        LOGGER.debug("reloadableConfigPath [{}]", (Object)Arrays.deepToString(reloadableConfigPath.toArray()));
        this.reloadableConfigPath = reloadableConfigPath;
        this.reload();
    }

    public static String get(ConfigKey key) {
        return config.getProperty(key.getKey());
    }

    public static String get(ConfigKey key, String defaultValue) {
        String value = config.getProperty(key.getKey());
        return null == value ? defaultValue : value;
    }

    public static List<String> getList(ConfigKey key) {
        String value = config.getProperty(key.getKey());
        return StringUtils.isBlank((CharSequence)value) ? Collections.emptyList() : Arrays.asList(value.split(","));
    }

    public static Set<String> getSet(ConfigKey key) {
        String value = config.getProperty(key.getKey());
        return StringUtils.isBlank((CharSequence)value) ? Collections.emptySet() : Stream.of(value.split(",")).collect(Collectors.toSet());
    }

    public static int getInt(ConfigKey key) {
        return Integer.parseInt(config.getProperty(key.getKey()));
    }

    public static Integer getInteger(ConfigKey key, Integer defaultValue) {
        String value = config.getProperty(key.getKey());
        return null == value ? defaultValue : Integer.valueOf(value);
    }

    public static long getLong(ConfigKey key) {
        return Long.parseLong(config.getProperty(key.getKey()));
    }

    public static Long getLong(ConfigKey key, Long defaultValue) {
        String value = config.getProperty(key.getKey());
        return null == value ? defaultValue : Long.valueOf(value);
    }

    public static boolean getBoolean(ConfigKey key) {
        return Boolean.parseBoolean(config.getProperty(key.getKey()));
    }

    public static Boolean getBoolean(ConfigKey key, Boolean defaultValue) {
        String value = config.getProperty(key.getKey());
        return StringUtils.isBlank((CharSequence)value) ? defaultValue : Boolean.valueOf(value);
    }

    public static short getShort(ConfigKey key) {
        return Short.parseShort(config.getProperty(key.getKey()));
    }

    public static Short getShort(ConfigKey key, Short defaultValue) {
        String value = config.getProperty(key.getKey());
        return null == value ? defaultValue : Short.valueOf(value);
    }

    @Scheduled(cron="${reloadableConfig.cron:*/30 * * * * *}")
    private void reload() throws IOException {
        Properties newConfigs = new Properties();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : this.reloadableConfigPath) {
            resources.addAll(Arrays.asList(ResourceUtils.getResources(path)));
        }
        for (Resource resource : resources) {
            LOGGER.debug("loading global config from uri [{}]", (Object)resource.getURI());
            if (!resource.exists()) {
                LOGGER.error("can't read config file in given uri [{}], reload config ignored", (Object)resource.getURI());
                return;
            }
            InputStream inputStream = resource.getInputStream();
            Throwable throwable = null;
            try {
                newConfigs.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        List<String> configErrors = this.check(newConfigs);
        if (!configErrors.isEmpty()) {
            StringBuilder log = new StringBuilder();
            log.append("\n**************************************************");
            log.append("\nconfig reload failed due errors, correct them and wait until next reload.\n");
            for (String configError : configErrors) {
                log.append("\n");
                log.append(configError);
            }
            log.append("\n**************************************************\n");
            LOGGER.error("config error {}", (Object)log);
            if (config.isEmpty()) {
                throw new IllegalStateException("config error, see previous error");
            }
            return;
        }
        config = newConfigs;
        LOGGER.info("load [{}] config entries successfully from [{}] files", (Object)newConfigs.keySet().size(), (Object)resources.size());
    }

    private List<String> check(Properties newConfigs) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Class aClass : ReflectionUtils.getSubTypeOf(ConfigKey.class)) {
            if (!aClass.isEnum()) continue;
            for (ConfigKey key : (ConfigKey[])aClass.getEnumConstants()) {
                String value = newConfigs.getProperty(key.getKey());
                if (key.isRequired()) {
                    if (!StringUtils.isBlank((CharSequence)value)) continue;
                    errors.add(String.format("[%s] config is required but not present in any config files", key.getKey()));
                    continue;
                }
                Object defaultValue = key.getDefaultValue();
                if (null == defaultValue || !StringUtils.isBlank((CharSequence)value)) continue;
                newConfigs.put(key.getKey(), defaultValue.toString());
            }
        }
        return errors;
    }
}

