/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.config.ConfigKey;
import org.bardframework.commons.utils.StringTemplateUtils;
import org.bardframework.commons.web.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.Scheduled;

public class ReloadableConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReloadableConfig.class);
    private static Properties config = new Properties();
    private static Collection<Class<? extends ConfigKey>> configClasses;
    private final Collection<String> reloadableConfigPath;

    public ReloadableConfig(Collection<String> reloadableConfigPath, Collection<Class<? extends ConfigKey>> configClasses) throws IOException {
        log.debug("reloadableConfigPath [{}], config entries: [{}]", (Object)Arrays.deepToString(reloadableConfigPath.toArray()), configClasses);
        this.reloadableConfigPath = reloadableConfigPath;
        ReloadableConfig.configClasses = configClasses;
        this.reload();
    }

    public static String get(ConfigKey<?, ?> key) {
        return ReloadableConfig.get(key, Map.of());
    }

    public static String get(ConfigKey<?, ?> key, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        value = StringTemplateUtils.fillTemplate((String)value, args);
        return value;
    }

    public static String get(ConfigKey<?, ?> key, String defaultValue) {
        return ReloadableConfig.get(key, defaultValue, Map.of());
    }

    public static String get(ConfigKey<?, ?> key, String defaultValue, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        return null == (value = StringTemplateUtils.fillTemplate((String)value, args)) ? defaultValue : value;
    }

    public static List<String> getList(ConfigKey<?, ?> key) {
        return ReloadableConfig.getList(key, Map.of());
    }

    public static List<String> getList(ConfigKey<?, ?> key, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        return StringUtils.isBlank((CharSequence)(value = StringTemplateUtils.fillTemplate((String)value, args))) ? Collections.emptyList() : List.of(value.split(","));
    }

    public static Set<String> getSet(ConfigKey<?, ?> key) {
        return ReloadableConfig.getSet(key, Map.of());
    }

    public static Set<String> getSet(ConfigKey<?, ?> key, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        return StringUtils.isBlank((CharSequence)(value = StringTemplateUtils.fillTemplate((String)value, args))) ? Collections.emptySet() : Stream.of(value.split(",")).collect(Collectors.toSet());
    }

    public static int getInt(ConfigKey<?, ?> key, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        value = StringTemplateUtils.fillTemplate((String)value, args);
        return Integer.parseInt(value);
    }

    public static int getInt(ConfigKey<?, ?> key) {
        String value = config.getProperty(key.getKey());
        return Integer.parseInt(value);
    }

    public static Integer getInteger(ConfigKey<?, ?> key, Integer defaultValue) {
        return ReloadableConfig.getInteger(key, defaultValue, Map.of());
    }

    public static Integer getInteger(ConfigKey<?, ?> key, Integer defaultValue, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        return null == (value = StringTemplateUtils.fillTemplate((String)value, args)) ? defaultValue : Integer.valueOf(value);
    }

    public static long getLong(ConfigKey<?, ?> key) {
        String value = config.getProperty(key.getKey());
        return Long.parseLong(value);
    }

    public static Long getLong(ConfigKey<?, ?> key, Long defaultValue) {
        return ReloadableConfig.getLong(key, defaultValue, Map.of());
    }

    public static Long getLong(ConfigKey<?, ?> key, Long defaultValue, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        return null == (value = StringTemplateUtils.fillTemplate((String)value, args)) ? defaultValue : Long.valueOf(value);
    }

    public static boolean getBoolean(ConfigKey<?, ?> key) {
        String value = config.getProperty(key.getKey());
        return Boolean.parseBoolean(value);
    }

    public static Boolean getBoolean(ConfigKey<?, ?> key, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        value = StringTemplateUtils.fillTemplate((String)value, args);
        return Boolean.parseBoolean(value);
    }

    public static Boolean getBoolean(ConfigKey<?, ?> key, Boolean defaultValue) {
        return ReloadableConfig.getBoolean(key, defaultValue, Map.of());
    }

    public static Boolean getBoolean(ConfigKey<?, ?> key, Boolean defaultValue, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        return StringUtils.isBlank((CharSequence)(value = StringTemplateUtils.fillTemplate((String)value, args))) ? defaultValue : Boolean.valueOf(value);
    }

    public static short getShort(ConfigKey<?, ?> key) {
        String value = config.getProperty(key.getKey());
        return Short.parseShort(value);
    }

    public static Short getShort(ConfigKey<?, ?> key, Short defaultValue) {
        return ReloadableConfig.getShort(key, defaultValue, Map.of());
    }

    public static Short getShort(ConfigKey<?, ?> key, Short defaultValue, Map<String, String> args) {
        String value = config.getProperty(key.getKey());
        return null == (value = StringTemplateUtils.fillTemplate((String)value, args)) ? defaultValue : Short.valueOf(value);
    }

    @Scheduled(cron="${reloadableConfig.cron:*/30 * * * * *}")
    private void reload() throws IOException {
        Properties newConfigs = new Properties();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String path : this.reloadableConfigPath) {
            resources.addAll(List.of(ResourceUtils.getResources((String)path)));
        }
        for (Resource resource : resources) {
            log.debug("loading global config from url [{}]", (Object)resource.getURL());
            if (!resource.exists()) {
                log.error("can't read config file in given url [{}], reload config ignored", (Object)resource.getURL());
                return;
            }
            InputStream inputStream = resource.getInputStream();
            try {
                newConfigs.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        List<String> configErrors = this.check(newConfigs);
        if (!configErrors.isEmpty()) {
            StringBuilder details = new StringBuilder();
            details.append("\n**************************************************");
            details.append("\nconfig reload failed due errors, correct them and wait until next reload.\n");
            for (String configError : configErrors) {
                details.append("\n");
                details.append(configError);
            }
            details.append("\n**************************************************\n");
            log.error("config error {}", (Object)details);
            if (config.isEmpty()) {
                throw new IllegalStateException("config error, see previous error");
            }
            return;
        }
        config = newConfigs;
        log.debug("load [{}] config entries successfully from [{}] files", (Object)newConfigs.keySet().size(), (Object)resources.size());
    }

    private List<String> check(Properties newConfigs) {
        ArrayList<String> errors = new ArrayList<String>();
        for (Class<? extends ConfigKey> aClass : configClasses) {
            for (ConfigKey key : aClass.getEnumConstants()) {
                String value = newConfigs.getProperty(key.getKey());
                if (key.isRequired()) {
                    if (!StringUtils.isBlank((CharSequence)value)) continue;
                    errors.add(String.format("[%s] config is required but not present in any config files", key.getKey()));
                    continue;
                }
                Object defaultValue = key.getDefaultValue();
                if (null == defaultValue || !StringUtils.isBlank((CharSequence)value)) continue;
                newConfigs.put(key.getKey(), defaultValue.toString());
            }
        }
        return errors;
    }

    @Generated
    public Collection<String> getReloadableConfigPath() {
        return this.reloadableConfigPath;
    }
}

