/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.jackson.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongToLocalDateTimeConverter
extends JsonDeserializer<LocalDateTime> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        try {
            return null == jsonParser.getValueAsString() ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(jsonParser.getValueAsLong()), ZoneOffset.UTC);
        }
        catch (Exception e) {
            this.logger.info("error when converting StringJalaliDate '{}' to LocalDate.", jsonParser.getCurrentValue());
            this.logger.debug("exception details:", (Throwable)e);
            return null;
        }
    }
}

