/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.redis;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bardframework.commons.redis.AsMapDeserializer;
import org.bardframework.commons.redis.AsMapSerializer;
import org.bardframework.commons.redis.DataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class DataManagerRedisImpl
implements DataManager {
    private static final Logger log = LoggerFactory.getLogger(DataManagerRedisImpl.class);
    private static final String ERROR_WRITE_VALUE = "error writing value";
    protected final RedisTemplate<String, Object> redisTemplate;
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JavaTimeModule());

    public DataManagerRedisImpl(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean isExist(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)key));
    }

    @Override
    public void putAsJson(String key, Object value, int expiration, TimeUnit unit) {
        try {
            String valueString = this.objectMapper.writeValueAsString(value);
            this.redisTemplate.opsForValue().set((Object)key, (Object)valueString, (long)expiration, unit);
        }
        catch (Exception e) {
            log.error("error putting [{}] to redis", value);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public void put(String key, String value, int expiration, TimeUnit unit) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, (Object)value, (long)expiration, unit);
        }
        catch (Exception e) {
            log.error("error putting [{}] to redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public String get(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    @Override
    public <T> T getFromJson(String tokenId, Class<T> clazz) {
        try {
            String valueString = (String)this.redisTemplate.opsForValue().get((Object)tokenId);
            if (null == valueString) {
                return null;
            }
            return (T)this.objectMapper.readValue(valueString, clazz);
        }
        catch (Exception e) {
            log.error("error getting value with key [{}] from redis server, and converting to [{}]", (Object)tokenId, clazz);
            throw new IllegalArgumentException("error getting value from server", e);
        }
    }

    @Override
    public boolean remove(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.delete((Object)key));
    }

    @Override
    public void addToSet(String key, String value, Long age, TimeUnit ageUnit) {
        try {
            this.redisTemplate.opsForSet().add((Object)key, new Object[]{value});
            this.redisTemplate.persist((Object)key);
            this.redisTemplate.expire((Object)key, age.longValue(), ageUnit);
        }
        catch (Exception e) {
            log.error("error putting [{}] to redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public Set<String> getFromSet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            log.error("error reading [{}] to redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public void removeFromSet(String key, String value, Long age, TimeUnit ageUnit) {
        try {
            this.redisTemplate.opsForSet().remove((Object)key, new Object[]{value});
            this.redisTemplate.persist((Object)key);
            this.redisTemplate.expire((Object)key, age.longValue(), ageUnit);
        }
        catch (Exception e) {
            log.error("error removing set value of [{}] from redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public void putAsMap(String key, Map<?, ?> map, Long age, TimeUnit ageUnit) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            this.redisTemplate.persist((Object)key);
            this.redisTemplate.expire((Object)key, age.longValue(), ageUnit);
        }
        catch (Exception e) {
            log.error("error putting [{}] to redis", (Object)key);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }

    @Override
    public void putAsMap(String key, AsMapSerializer object, Long age, TimeUnit ageUnit) {
        this.putAsMap(key, object.getAsMap(), age, ageUnit);
    }

    @Override
    public <T extends AsMapDeserializer> T getFromMap(String key, Class<T> clazz) {
        try {
            Map map = this.redisTemplate.opsForHash().entries((Object)key);
            if (map.isEmpty()) {
                return null;
            }
            AsMapDeserializer object = (AsMapDeserializer)clazz.newInstance();
            object.init(map);
            return (T)object;
        }
        catch (Exception e) {
            log.error("error getting value with key [{}] from redis server", (Object)key);
            throw new IllegalArgumentException("error getting value from server", e);
        }
    }

    @Override
    public Object getFromMap(String key, String hashKey) {
        try {
            return this.redisTemplate.opsForHash().get((Object)key, (Object)hashKey);
        }
        catch (Exception e) {
            log.error("error getting value with key [{}] from redis server", (Object)key);
            throw new IllegalArgumentException("error getting value from server", e);
        }
    }

    @Override
    public void removeFromMap(String userId, String topic, Long age, TimeUnit ageUnit) {
        try {
            this.redisTemplate.opsForHash().delete((Object)userId, new Object[]{topic});
            this.redisTemplate.expire((Object)userId, age.longValue(), ageUnit);
        }
        catch (Exception e) {
            log.error("error removing map key of [{}] from redis", (Object)userId);
            throw new IllegalArgumentException(ERROR_WRITE_VALUE, e);
        }
    }
}

