/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.reflection;

import java.io.File;
import org.bardframework.commons.utils.FileUtils;

class FileToClassConverter {
    private String classPathRoot;

    public FileToClassConverter(String classPathRoot) {
        this.setClassPathRoot(classPathRoot);
    }

    public void setClassPathRoot(String classPathRoot) {
        if (classPathRoot == null) {
            throw new RuntimeException("Class path root must not be null");
        }
        this.classPathRoot = classPathRoot;
    }

    public Class convertToClass(File classFile) {
        Class classInstance = null;
        if (classFile.getAbsolutePath().startsWith(this.classPathRoot) && classFile.getAbsolutePath().endsWith(".class")) {
            classInstance = this.getClassFromName(classFile.getAbsolutePath());
        }
        return classInstance;
    }

    private Class getClassFromName(String fileName) {
        try {
            String className = this.removeClassPathBase(fileName);
            className = FileUtils.removeExtension((String)className);
            return Class.forName(className);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String removeClassPathBase(String fileName) {
        String classPart = fileName.substring(this.classPathRoot.length() + 1);
        return classPart.replace(File.separatorChar, '.');
    }
}

