/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.reflection;

import java.io.File;
import java.io.FileFilter;
import org.bardframework.commons.reflection.FileFindHandler;
import org.bardframework.commons.reflection.FileFindHandlerAdapter;
import org.bardframework.commons.reflection.MatchAllFileFilter;

class FileWalker {
    private FileFilter matchFilter;
    private FileFindHandler handler;
    private String baseDir;
    private int matchingFiles;
    private int allFiles;

    public FileWalker() {
        this(new MatchAllFileFilter(), new FileFindHandlerAdapter());
    }

    public FileWalker(FileFilter matchFilter) {
        this(matchFilter, new FileFindHandlerAdapter());
    }

    public FileWalker(FileFindHandler handler) {
        this(new MatchAllFileFilter(), handler);
    }

    public FileWalker(FileFilter matchFilter, FileFindHandler handler) {
        this.matchFilter = matchFilter;
        this.handler = handler;
    }

    public FileFilter getMatchFilter() {
        return this.matchFilter;
    }

    public void setMatchFilter(FileFilter matchFilter) {
        this.matchFilter = matchFilter;
    }

    public FileFindHandler getHandler() {
        return this.handler;
    }

    public void setHandler(FileFindHandler handler) {
        this.handler = handler;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void walk() {
        try {
            File rootDir = new File(this.baseDir);
            this.walk(rootDir);
            this.handler.onComplete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void walk(File currentDir) {
        File[] files = currentDir.listFiles();
        if (null == files) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.walk(file);
                continue;
            }
            if (this.matchFilter.accept(file)) {
                ++this.matchingFiles;
                this.handler.handleFile(file);
            }
            ++this.allFiles;
        }
    }

    public int getMatchingFileCount() {
        return this.matchingFiles;
    }

    public int getAllFilesCount() {
        return this.allFiles;
    }
}

