/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.reflection;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bardframework.commons.reflection.FileFindHandlerAdapter;
import org.bardframework.commons.reflection.FileToClassConverter;
import org.bardframework.commons.reflection.JavaClassFileWalker;

class JavaClassFinder {
    public static final String JAVA_CLASS_PATH_PROPERTY = "java.class.path";
    public static final String CUSTOM_CLASS_PATH_PROPERTY = "custom.class.path";
    private ArrayList<Class<?>> foundClasses;
    private Class<?> toFind;
    private JavaClassFileWalker fileWalker;
    private ClassLoadingFileHandler fileHandler;

    JavaClassFinder() {
    }

    public <T> List<Class<? extends T>> findAllMatchingTypes(Class<T> toFind) {
        this.foundClasses = new ArrayList();
        ArrayList<Class<T>> returnedClasses = new ArrayList<Class<T>>();
        this.toFind = toFind;
        this.walkClassPath();
        for (Class<?> clazz : this.foundClasses) {
            returnedClasses.add(clazz);
        }
        return returnedClasses;
    }

    private void walkClassPath() {
        String[] classPathRoots;
        this.fileHandler = new ClassLoadingFileHandler();
        this.fileWalker = new JavaClassFileWalker(this.fileHandler);
        for (String path : classPathRoots = this.getClassPathRoots()) {
            if (path.endsWith(".jar")) continue;
            this.fileHandler.updateClassPathBase(path);
            this.fileWalker.setBaseDir(path);
            this.fileWalker.walk();
        }
    }

    public String[] getClassPathRoots() {
        String classPath = System.getProperties().containsKey(CUSTOM_CLASS_PATH_PROPERTY) ? System.getProperty(CUSTOM_CLASS_PATH_PROPERTY) : System.getProperty(JAVA_CLASS_PATH_PROPERTY);
        return classPath.split(File.pathSeparator);
    }

    private void handleClass(Class<?> clazz) {
        boolean isMatch;
        boolean bl = isMatch = this.toFind == null || this.toFind.isAssignableFrom(clazz);
        if (isMatch) {
            this.foundClasses.add(clazz);
        }
    }

    public List<Class<?>> findAllMatchingTypes() {
        return this.findAllMatchingTypes(null);
    }

    public int getScannedClassesCount() {
        if (this.fileWalker == null) {
            return 0;
        }
        return this.fileWalker.getAllFilesCount();
    }

    class ClassLoadingFileHandler
    extends FileFindHandlerAdapter {
        private FileToClassConverter converter;

        ClassLoadingFileHandler() {
        }

        public void updateClassPathBase(String classPathRoot) {
            if (this.converter == null) {
                this.converter = new FileToClassConverter(classPathRoot);
            }
            this.converter.setClassPathRoot(classPathRoot);
        }

        @Override
        public void handleFile(File file) {
            Class clazz = this.converter.convertToClass(file);
            if (clazz == null) {
                return;
            }
            JavaClassFinder.this.handleClass(clazz);
        }
    }
}

