/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.security.context;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bardframework.commons.security.context.SecurityContextManager;
import org.bardframework.commons.security.token.AuthenticationAbstract;
import org.bardframework.commons.security.token.manager.TokenManager;
import org.bardframework.commons.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class SecurityContextManagerAbstract<A extends AuthenticationAbstract<U>, U>
implements SecurityContextManager<A, U> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final TokenManager<A> tokenManager;
    protected String tokenName = "token";

    protected SecurityContextManagerAbstract(TokenManager<A> tokenManager) {
        this.tokenManager = tokenManager;
    }

    @Override
    public void setSecurityContext(HttpServletRequest request, HttpServletResponse response) {
        String tokenId = this.getToken(request);
        if (StringUtils.hasNotText((String)tokenId)) {
            SecurityContextHolder.clearContext();
            return;
        }
        AuthenticationAbstract token = (AuthenticationAbstract)this.tokenManager.get(tokenId);
        if (null == token) {
            this.LOGGER.info("detect invalid token, destroying it. '{}'", (Object)tokenId);
            this.deleteTicket(request, response);
            SecurityContextHolder.clearContext();
        } else {
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        }
    }

    @Override
    public void clearSecurityContext(HttpServletRequest request, HttpServletResponse response) {
        String token = this.getToken(request);
        if (null != token) {
            this.tokenManager.remove(token);
            this.deleteTicket(request, response);
            SecurityContextHolder.clearContext();
        }
    }

    @Override
    public String putAuthentication(A authentication, HttpServletResponse response) {
        String tokenId = this.tokenManager.put(authentication);
        this.setToken(response, tokenId);
        return tokenId;
    }

    @Override
    public A getAuthentication(HttpServletRequest request) {
        String token = this.getToken(request);
        if (null == token) {
            return null;
        }
        return (A)((AuthenticationAbstract)this.tokenManager.get(token));
    }

    @Override
    public U getUser(HttpServletRequest request) {
        String tokenId = this.getToken(request);
        if (null == tokenId) {
            return null;
        }
        AuthenticationAbstract token = (AuthenticationAbstract)this.tokenManager.get(tokenId);
        return null == token ? null : (U)token.getUser();
    }

    @Override
    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    protected abstract String getToken(HttpServletRequest var1);

    protected abstract void deleteTicket(HttpServletRequest var1, HttpServletResponse var2);
}

