/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.security.context;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bardframework.commons.security.context.SecurityContextManagerAbstract;
import org.bardframework.commons.security.token.AuthenticationAbstract;
import org.bardframework.commons.security.token.manager.TokenManager;

public abstract class CookieSecurityContextManagerAbstract<A extends AuthenticationAbstract<U>, U>
extends SecurityContextManagerAbstract<A, U> {
    public CookieSecurityContextManagerAbstract(TokenManager<A> tokenManager) {
        super(tokenManager);
    }

    @Override
    public void setToken(HttpServletResponse response, String tokenId) {
        response.addCookie(new Cookie(this.tokenName, tokenId));
    }

    @Override
    protected String getToken(HttpServletRequest request) {
        if (null == request.getCookies()) {
            return null;
        }
        for (Cookie cookie : request.getCookies()) {
            if (!this.tokenName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    @Override
    public void deleteTicket(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie(this.tokenName, null);
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }
}

