/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.security.token.manager;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bardframework.commons.security.token.manager.Token;
import org.bardframework.commons.security.token.manager.TokenManager;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class TokenManagerInMemory<T extends Token>
implements TokenManager<T> {
    protected final Map<String, T> tokensMap = new ConcurrentHashMap<String, T>();
    protected final long tokenExpirationMills;

    protected TokenManagerInMemory(long tokenExpirationMills) {
        this.tokenExpirationMills = tokenExpirationMills;
    }

    @Override
    public String put(T token) {
        String tokenId = UUID.randomUUID() + "-" + System.nanoTime();
        this.getTokensMap().put(tokenId, token);
        return tokenId;
    }

    @Override
    public boolean remove(String tokenId) {
        return this.getTokensMap().remove(tokenId) != null;
    }

    @Override
    public T get(String tokenId) {
        Token tokenInfo = (Token)this.getTokensMap().get(tokenId);
        if (null == tokenInfo) {
            return null;
        }
        if (tokenInfo.isExpired(this.getTokenExpirationMills())) {
            this.remove(tokenId);
            return null;
        }
        return (T)tokenInfo;
    }

    @Scheduled(cron="${token.manager.cleaner.cron:0 */1 * * * *}")
    public void cleanExpired() {
        this.getTokensMap().entrySet().parallelStream().filter(entry -> ((Token)entry.getValue()).isExpired(this.getTokenExpirationMills())).forEach(entry -> this.getTokensMap().remove(entry.getKey()));
    }

    @Generated
    public Map<String, T> getTokensMap() {
        return this.tokensMap;
    }

    @Generated
    public long getTokenExpirationMills() {
        return this.tokenExpirationMills;
    }
}

