/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.sms;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.sms.SmsSender;
import org.bardframework.commons.utils.http.HttpCallResponse;
import org.bardframework.commons.utils.http.HttpCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsSenderHttpCall
extends HttpCaller
implements SmsSender {
    private static final Logger log = LoggerFactory.getLogger(SmsSenderHttpCall.class);
    protected final Pattern successPattern;

    public SmsSenderHttpCall(String httpMethod, String urlTemplate, String successPattern) {
        super(httpMethod, urlTemplate);
        this.successPattern = Pattern.compile(successPattern);
    }

    @Override
    public final boolean send(Map<String, String> args) throws IOException {
        String receiverNumberForLog = StringUtils.overlay((String)args.get("to"), (String)"*", (int)4, (int)(args.get("to").length() - 4));
        log.info("try sending sms to: {}", (Object)receiverNumberForLog);
        HttpCallResponse callResult = this.call(this.prepareHeadersForSend(), args);
        log.info("http status of sending sms to [{}] is [{}]", (Object)receiverNumberForLog, (Object)callResult.getStatusCode());
        return this.isSuccess(callResult, receiverNumberForLog, args);
    }

    protected boolean isSuccess(HttpCallResponse result, String receiverNumberForLog, Map<String, String> args) throws IOException {
        if (null != result.getError()) {
            return false;
        }
        String body = new String(result.getBody(), StandardCharsets.UTF_8);
        if (null != this.getSuccessPattern()) {
            Matcher matcher = this.getSuccessPattern().matcher(body);
            return matcher.matches() || matcher.find();
        }
        return true;
    }

    protected Map<String, String> prepareHeadersForSend() throws IOException {
        return this.headers;
    }

    public Pattern getSuccessPattern() {
        return this.successPattern;
    }
}

