/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.spring.boot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.bardframework.commons.utils.CharsetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public interface SpringBootRunner {
    public static void run(Class<?> applicationClass, String[] args) {
        SpringApplication.run(applicationClass, (String[])args);
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer placeHolderConfigurer() throws IOException {
        PropertySourcesPlaceholderConfigurer propertyConfigurer = new PropertySourcesPlaceholderConfigurer();
        ArrayList<Resource> resources = new ArrayList<Resource>(Arrays.asList(new PathMatchingResourcePatternResolver().getResources("classpath*:**/**-config.properties")));
        resources.addAll(Arrays.asList(new PathMatchingResourcePatternResolver().getResources("classpath*:**/**/application.properties")));
        propertyConfigurer.setLocations(resources.toArray(new Resource[0]));
        return propertyConfigurer;
    }

    @EventListener
    default public void handleContextRefresh(ContextRefreshedEvent event) {
        Environment environment = event.getApplicationContext().getEnvironment();
        Logger logger = LoggerFactory.getLogger((String)"App Config");
        MutablePropertySources sources = ((AbstractEnvironment)environment).getPropertySources();
        StringBuilder configs = new StringBuilder();
        configs.append("Active profiles");
        configs.append("=");
        configs.append(Arrays.toString(environment.getActiveProfiles()));
        configs.append("\n");
        StreamSupport.stream(sources.spliterator(), false).filter(propertySource -> propertySource instanceof EnumerablePropertySource).map(propertySource -> ((EnumerablePropertySource)propertySource).getPropertyNames()).flatMap(Arrays::stream).forEach(property -> {
            configs.append((String)property);
            configs.append("=");
            configs.append(property.toLowerCase().contains("credential") || property.toLowerCase().contains("password") ? "*****" : environment.getProperty(property));
            configs.append("\n");
        });
        configs.append("DefaultCharset=");
        configs.append(CharsetUtils.getDefaultCharset());
        configs.append("\nDefaultLocale=");
        configs.append(CharsetUtils.getDefaultLocale());
        configs.append("\nDefaultEncoding=");
        configs.append(CharsetUtils.getDefaultEncoding());
        logger.info("\n\n====== configuration ======\n{}\n====== configuration ======\n", (Object)configs);
    }
}

