/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.spring.boot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bardframework.commons.utils.CharsetUtils;
import org.bardframework.commons.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
public class ConfigsConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigsConfiguration.class);
    private static final String CLASS_PATH_KEY = "java.class.path";
    private static final String SEPARATOR_KEY = "path.separator";
    private static final Set<String> SENSITIVE_KEYS = new HashSet<String>(Arrays.asList("password", "credential", "secret"));
    private static final Set<String> NOT_LOG_KEYS = new HashSet<String>(Arrays.asList("java.class.path"));

    @Bean
    static PropertySourcesPlaceholderConfigurer placeHolderConfigurer(Environment environment) throws IOException {
        PathMatchingResourcePatternResolver patternResolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> resources = new ArrayList<Resource>(Arrays.asList(patternResolver.getResources("classpath*:**/**-config.properties")));
        resources.addAll(Arrays.asList(patternResolver.getResources("classpath*:**/**/application.properties")));
        for (String profile : environment.getActiveProfiles()) {
            resources.addAll(Arrays.asList(patternResolver.getResources("classpath*:**/**/application-" + profile + ".properties")));
        }
        ConfigsConfiguration.logConfigs(environment, resources);
        PropertySourcesPlaceholderConfigurer propertyConfigurer = new PropertySourcesPlaceholderConfigurer();
        propertyConfigurer.setLocations(resources.toArray(new Resource[0]));
        return propertyConfigurer;
    }

    private static void logConfigs(Environment environment, List<Resource> resources) {
        MutablePropertySources sources = ((AbstractEnvironment)environment).getPropertySources();
        StringBuilder configs = new StringBuilder();
        ConfigsConfiguration.append(configs, "Active profiles", Arrays.toString(environment.getActiveProfiles()));
        String classpath = environment.getProperty(CLASS_PATH_KEY);
        String separator = environment.getProperty(SEPARATOR_KEY);
        ConfigsConfiguration.append(configs, "Config Files", resources.stream().map(resource -> {
            try {
                return String.valueOf(resource.getURI());
            }
            catch (IOException e) {
                LOGGER.error("error get config resource[{}] as uri", resource, (Object)e);
                return String.valueOf(resource);
            }
        }).collect(Collectors.joining("\n\t")));
        if (StringUtils.isNotEmpty((CharSequence)classpath) && StringUtils.isNotEmpty((CharSequence)separator)) {
            ConfigsConfiguration.append(configs, CLASS_PATH_KEY, Arrays.stream(classpath.split(separator)).map(Object::toString).collect(Collectors.joining("\n\t")));
        } else {
            LOGGER.info("classpath[{}] or separator[{}] is not valid", (Object)classpath, (Object)separator);
            ConfigsConfiguration.append(configs, CLASS_PATH_KEY, classpath);
        }
        ConfigsConfiguration.append(configs, "DefaultCharset", String.valueOf(CharsetUtils.getDefaultCharset()));
        ConfigsConfiguration.append(configs, "DefaultLocale", String.valueOf(CharsetUtils.getDefaultLocale()));
        ConfigsConfiguration.append(configs, "DefaultEncoding", String.valueOf(CharsetUtils.getDefaultEncoding()));
        StreamSupport.stream(sources.spliterator(), false).filter(propertySource -> propertySource instanceof EnumerablePropertySource).map(propertySource -> ((EnumerablePropertySource)propertySource).getPropertyNames()).flatMap(Arrays::stream).forEach(property -> {
            if (!NOT_LOG_KEYS.contains(property.toLowerCase())) {
                if (SENSITIVE_KEYS.contains(property.toLowerCase())) {
                    ConfigsConfiguration.append(configs, property, "*****");
                } else {
                    ConfigsConfiguration.append(configs, property, environment.getProperty(property));
                }
            }
        });
        LOGGER.info("\n\n====== configuration ======\n{}====== configuration ======\n", (Object)configs);
    }

    private static void append(StringBuilder configs, String key, String value) {
        configs.append(key);
        configs.append(": ");
        configs.append(value);
        configs.append("\n");
    }
}

