/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.persian;

import java.util.ArrayList;
import java.util.List;

public final class UtilityMethods {
    private static final String[] s_0_9 = new String[]{"\u0635\u0641\u0631", "\u06cc\u06a9", "\u062f\u0648", "\u0633\u0647", "\u0686\u0647\u0627\u0631", "\u067e\u0646\u062c", "\u0634\u0634", "\u0647\u0641\u062a", "\u0647\u0634\u062a", "\u0646\u0647"};
    private static final String[] s_10_19 = new String[]{"\u062f\u0647", "\u06cc\u0627 \u0632\u062f\u0647", "\u062f\u0648\u0627\u0632\u062f\u0647", "\u0633\u06cc\u0632\u062f\u0647", "\u0686\u0647\u0627\u0631\u062f\u0647", "\u067e\u0627 \u0646\u0632\u062f\u0647", "\u0634\u0627 \u0646\u0632\u062f\u0647", "\u0647\u0641\u062f\u0647", "\u0647\u062c\u062f\u0647", "\u0646\u0648\u0632\u062f\u0647"};
    private static final String[] s_20_90 = new String[]{"\u0628\u06cc\u0633\u062a", "\u0633\u06cc", "\u0686\u0647\u0644", "\u067e\u0646\u062c\u0627\u0647", "\u0634\u0635\u062a", "\u0647\u0641\u062a\u0627\u062f", "\u0647\u0634\u062a\u0627\u062f", "\u0646\u0648\u062f"};
    private static final String[] s_100_900 = new String[]{"\u0635\u062f", "\u062f\u0648\u06cc\u0633\u062a", "\u0633\u06cc\u0635\u062f", "\u0686\u0647\u0627\u0631\u0635\u062f", "\u067e\u0627\u0646\u0635\u062f", "\u0634\u0634\u0635\u062f", "\u0647\u0641\u062a\u0635\u062f", "\u0647\u0634\u062a\u0635\u062f", "\u0646\u0647\u0635\u062f"};
    private static final String[] s_Parts = new String[]{"\u0647\u0632\u0627\u0631", "\u0645\u06cc\u0644\u06cc\u0648\u0646", "\u0645\u06cc\u0644\u06cc\u0627\u0631\u062f", "\u062a\u0631\u064a\u0644\u064a\u0648\u0646"};
    private static final String SPLITTER = " \u0648 ";
    private static final String VERY_BIG = "\u062a\u0639\u0631\u06cc\u0641 \u0646\u0634\u062f\u0647";
    private static final String NEGATIVE = "\u0645\u0646\u0641\u06cc";

    private UtilityMethods() {
    }

    public static boolean getBoolean(Object object) {
        if (object == null) {
            return false;
        }
        String value = object.toString().trim();
        return "1".equals(value) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    public static String numberToAlphabet(long number) {
        String tempStringNumberOrgin = String.valueOf(number);
        String tempStringNumber = tempStringNumberOrgin.replaceAll("-", "");
        if (number == 0L) {
            return s_0_9[0];
        }
        int partCount = tempStringNumber.length() / 3;
        if (s_Parts.length < (partCount += tempStringNumber.length() % 3 > 0 ? 1 : 0) - 1) {
            return VERY_BIG;
        }
        ArrayList<String> partFullString = new ArrayList<String>();
        int lengthToSelectFirstPart = 0;
        for (int i = 0; i < partCount; ++i) {
            String numberLength3;
            if (i == 0) {
                lengthToSelectFirstPart = tempStringNumber.length() - (partCount - 1) * 3;
                numberLength3 = tempStringNumber.substring(i * 3, lengthToSelectFirstPart);
            } else {
                numberLength3 = tempStringNumber.substring(lengthToSelectFirstPart + (i - 1) * 3).substring(0, 3);
            }
            String numberIn3 = numberLength3;
            if (numberIn3.length() > 3) {
                return "";
            }
            switch (numberIn3.length()) {
                case 1: {
                    numberIn3 = "00" + numberIn3;
                    break;
                }
                case 2: {
                    numberIn3 = "0" + numberIn3;
                    break;
                }
                default: {
                    numberIn3 = "";
                }
            }
            int n1 = Integer.parseInt(numberIn3.substring(0, 1));
            int n2 = Integer.parseInt(numberIn3.substring(1, 2));
            int n3 = Integer.parseInt(numberIn3.substring(2, 3));
            String partInWord = UtilityMethods.findPartInWord(n1, n2, n3);
            UtilityMethods.addPartFullString(partFullString, partInWord, partCount, i);
        }
        StringBuilder outString = new StringBuilder();
        for (String aPartFullString : partFullString) {
            outString.append(aPartFullString);
        }
        if ("-".equals(tempStringNumberOrgin.substring(0, 1))) {
            outString.append(NEGATIVE);
            outString.append(' ');
            outString.append((CharSequence)outString);
        }
        return outString.toString();
    }

    private static String findPartInWord(int num1, int num2, int num3) {
        String part = num1 != 0 ? UtilityMethods.partInWord(num1, num2, num3) : UtilityMethods.partInWordBig(num2, num3);
        return part;
    }

    private static String partInWord(int num1, int num2, int num3) {
        String part;
        switch (num2) {
            case 0: {
                if (num3 != 0) {
                    part = s_100_900[num1 - 1] + SPLITTER + s_0_9[num3];
                    break;
                }
                part = s_100_900[num1 - 1];
                break;
            }
            case 1: {
                part = s_100_900[num1 - 1] + SPLITTER + s_10_19[num3];
                break;
            }
            default: {
                part = num3 != 0 ? s_100_900[num1 - 1] + SPLITTER + s_20_90[num2 - 2] + SPLITTER + s_0_9[num3] : s_100_900[num1 - 1] + SPLITTER + s_20_90[num2 - 2];
            }
        }
        return part;
    }

    private static String partInWordBig(int num2, int num3) {
        String part;
        switch (num2) {
            case 0: {
                if (num3 != 0) {
                    part = s_0_9[num3];
                    break;
                }
                part = "";
                break;
            }
            case 1: {
                part = s_10_19[num3];
                break;
            }
            default: {
                part = num3 != 0 ? s_20_90[num2 - 2] + SPLITTER + s_0_9[num3] : s_20_90[num2 - 2];
            }
        }
        return part;
    }

    private static void addPartFullString(List<String> partFullString, String partInWord, int partCount, int index) {
        int partIndex = partCount - 2 - index;
        partIndex = Math.max(partIndex, 0);
        String partPreFix = s_Parts[partIndex];
        if (index == partCount - 1) {
            partPreFix = "";
        }
        if (index == 0) {
            if ("".equals(partInWord)) {
                partFullString.add(index, "");
            } else {
                partFullString.add(index, partInWord + " " + partPreFix);
            }
        } else {
            UtilityMethods.addParts(partFullString, partInWord, partPreFix, index);
        }
    }

    private static void addParts(List<String> partFullString, String partInWord, String partPreFix, int index) {
        if (!"".equals(partFullString.get(index - 1))) {
            if (!"".equals(partInWord)) {
                partFullString.add(index, SPLITTER + partInWord + " " + partPreFix);
            } else {
                partFullString.add(index, "");
            }
        } else if (!"".equals(partInWord)) {
            partFullString.add(index, SPLITTER + partInWord + "" + partPreFix);
        } else {
            partFullString.add(index, " ");
        }
    }
}

