/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.jackson.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.bardframework.commons.utils.persian.LetterConverterUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArabicToPersianCharacterSerializer
extends JsonSerializer<String> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void serialize(String string, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        try {
            if (string != null) {
                jsonGenerator.writeString(LetterConverterUtility.convertArabicCharacters(string));
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("error when normal '{}' to persian character", (Object)string, (Object)e);
        }
        jsonGenerator.writeNull();
    }
}

