/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.jackson.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.bardframework.commons.utils.persian.LetterConverterUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArabicToPersianCharacterSerializer
extends JsonSerializer<String> {
    private static final Logger log = LoggerFactory.getLogger(ArabicToPersianCharacterSerializer.class);

    public void serialize(String string, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        try {
            if (string != null) {
                jsonGenerator.writeString(LetterConverterUtility.convertArabicCharacters(string));
                return;
            }
        }
        catch (Exception e) {
            log.error("error when normal '{}' to persian character", (Object)string, (Object)e);
        }
        jsonGenerator.writeNull();
    }
}

