/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Locale;

public abstract class CharsetUtils {
    private CharsetUtils() {
    }

    public static Charset toCharset(String charset) {
        return charset == null ? Charset.defaultCharset() : Charset.forName(charset);
    }

    public static Charset toCharset(Charset charset) {
        return charset == null ? Charset.defaultCharset() : charset;
    }

    public static String getDefaultEncoding() {
        byte[] bytes = new byte[]{68};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader(inputStream);
        return reader.getEncoding();
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public static Charset getDefaultCharset() {
        return Charset.defaultCharset();
    }

    public static String getSunEncoding() {
        return System.getProperty("sun.jnu.encoding");
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }
}

