/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.util.Random;
import org.bardframework.commons.utils.AssertionUtils;

public class RandomUtils {
    private static final Random RANDOM = new Random();

    public static boolean nextBoolean() {
        return RANDOM.nextBoolean();
    }

    public static byte[] nextBytes(int count) {
        AssertionUtils.isTrue(count >= 0, "Count cannot be negative.");
        byte[] result = new byte[count];
        RANDOM.nextBytes(result);
        return result;
    }

    public static int nextInt(int startInclusive, int endExclusive) {
        AssertionUtils.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.");
        AssertionUtils.isTrue(startInclusive >= 0, "Both range values must be non-negative.");
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return startInclusive + RANDOM.nextInt(endExclusive - startInclusive);
    }

    public static int nextInt() {
        return RandomUtils.nextInt(0, Integer.MAX_VALUE);
    }

    public static long nextLong(long startInclusive, long endExclusive) {
        AssertionUtils.isTrue(endExclusive >= startInclusive, "Start value must be smaller or equal to end value.");
        AssertionUtils.isTrue(startInclusive >= 0L, "Both range values must be non-negative.");
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return (long)RandomUtils.nextDouble(startInclusive, endExclusive);
    }

    public static long nextLong() {
        return RandomUtils.nextLong(0L, Long.MAX_VALUE);
    }

    public static double nextDouble(double startInclusive, double endInclusive) {
        AssertionUtils.isTrue(endInclusive >= startInclusive, "Start value must be smaller or equal to end value.");
        AssertionUtils.isTrue(startInclusive >= 0.0, "Both range values must be non-negative.");
        if (startInclusive == endInclusive) {
            return startInclusive;
        }
        return startInclusive + (endInclusive - startInclusive) * RANDOM.nextDouble();
    }

    public static double nextDouble() {
        return RandomUtils.nextDouble(0.0, Double.MAX_VALUE);
    }

    public static float nextFloat(float startInclusive, float endInclusive) {
        AssertionUtils.isTrue(endInclusive >= startInclusive, "Start value must be smaller or equal to end value.");
        AssertionUtils.isTrue(startInclusive >= 0.0f, "Both range values must be non-negative.");
        if (startInclusive == endInclusive) {
            return startInclusive;
        }
        return startInclusive + (endInclusive - startInclusive) * RANDOM.nextFloat();
    }

    public static float nextFloat() {
        return RandomUtils.nextFloat(0.0f, Float.MAX_VALUE);
    }
}

