/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeUtils {
    public static final long YEAR_DURATION_MILLS = 31536000000L;
    private static final Logger log = LoggerFactory.getLogger(DateTimeUtils.class);
    private static final ZoneId UTCZone = ZoneOffset.UTC;

    public static long toEpochMills(LocalDate date) {
        if (null == date) {
            throw new IllegalArgumentException("null date not acceptable.");
        }
        return date.toEpochDay() * 24L * 60L * 60L * 1000L;
    }

    public static LocalDate fromEpochMills(long dateAsMills) {
        return DateTimeUtils.fromEpochMills(dateAsMills, UTCZone).toLocalDate();
    }

    public static LocalDateTime dateTimeFromEpochMills(long dateTimeAsMills) {
        return DateTimeUtils.fromEpochMills(dateTimeAsMills, UTCZone);
    }

    public static LocalDateTime fromEpochMills(long dateTimeAsMills, ZoneId zone) {
        if (null == zone) {
            throw new IllegalArgumentException("null zone not acceptable.");
        }
        return Instant.ofEpochMilli(dateTimeAsMills).atZone(zone).toLocalDateTime();
    }

    public static long toEpochMills(LocalDateTime dateTime) {
        if (null == dateTime) {
            throw new IllegalArgumentException("null dateTime not acceptable.");
        }
        return DateTimeUtils.toEpochMills(dateTime.toLocalDate()) + (long)(dateTime.getHour() * 60 * 60) * 1000L + (long)(dateTime.getMinute() * 60) * 1000L + (long)dateTime.getSecond() * 1000L + (long)(dateTime.getNano() / 1000000);
    }

    public static long toEpochMills(OffsetDateTime dateTime) {
        if (null == dateTime) {
            throw new IllegalArgumentException("null dateTime not acceptable.");
        }
        return DateTimeUtils.toEpochMills(dateTime.toLocalDate()) + (long)(dateTime.getHour() * 60 * 60) * 1000L + (long)(dateTime.getMinute() * 60) * 1000L + (long)dateTime.getSecond() * 1000L + (long)(dateTime.getNano() / 1000000);
    }

    public static String toLocalString(LocalDateTime dateTime) {
        return null == dateTime ? "" : dateTime.format(DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm"));
    }

    public static String toLocalString(LocalDate date) {
        return null == date ? "" : date.format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
    }

    public static TimeUnit toTimeUnit(ChronoUnit unit) {
        if (unit == null) {
            return null;
        }
        switch (unit) {
            case DAYS: {
                return TimeUnit.DAYS;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MICROS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLIS: {
                return TimeUnit.MILLISECONDS;
            }
            case NANOS: {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new UnsupportedOperationException("Man, use a real temporal unit");
    }

    public static ChronoUnit toChronoUnit(TimeUnit unit) {
        if (unit == null) {
            return null;
        }
        switch (unit) {
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
        }
        assert (false) : "there are no other TimeUnit ordinal values";
        return null;
    }

    public static long getNowUtcMills() {
        return DateTimeUtils.toEpochMills(LocalDateTime.now(ZoneOffset.UTC));
    }

    private DateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

