/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.StringTemplateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UrlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlUtils.class);

    private UrlUtils() {
    }

    public static String makeCleanUrl(String ... parts) {
        if (null == parts) {
            throw new IllegalArgumentException("null string array not acceptable");
        }
        StringBuilder all = new StringBuilder();
        for (String part : parts) {
            if (!StringUtils.isNotBlank((CharSequence)part)) continue;
            all.append(part);
            all.append('/');
        }
        String url = all.toString().replaceFirst("://", "%%%%");
        while (url.contains("//")) {
            url = url.replace("//", "/");
        }
        url = StringUtils.removeEnd((String)url, (String)"/");
        url = StringUtils.removeStart((String)url, (String)"/");
        return url.replaceFirst("%%%%", "://").replaceFirst("///", "//");
    }

    public static String urlEncode(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String fillUrlTemplate(String urlTemplate, Map<String, String> args) {
        return StringTemplateUtils.fillTemplate(urlTemplate, UrlUtils.urlEncodeValues(args));
    }

    public static String fillUrlTemplate(String urlTemplate, String prefix, String suffix, Map<String, String> args) {
        return StringTemplateUtils.fillTemplate(urlTemplate, prefix, suffix, UrlUtils.urlEncodeValues(args));
    }

    public static Map<String, String> urlEncodeValues(Map<String, String> args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : args.entrySet()) {
            String value = StringTemplateUtils.fillTemplate(entry.getValue(), args);
            map.put(entry.getKey(), UrlUtils.urlEncode(value));
        }
        return map;
    }
}

