/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsUtils.class);
    private static final MBeanServer M_BEAN_SERVER = ManagementFactory.getPlatformMBeanServer();

    private OsUtils() {
    }

    public static int getCpuUsagePercent() {
        try {
            ObjectName name = ObjectName.getInstance("java.lang:type=OperatingSystem");
            AttributeList list = M_BEAN_SERVER.getAttributes(name, new String[]{"ProcessCpuLoad"});
            if (list.isEmpty()) {
                return 0;
            }
            Attribute att = (Attribute)list.get(0);
            Double value = (Double)att.getValue();
            if (value == -1.0) {
                return 0;
            }
            return (int)(value * 1000.0) / 10;
        }
        catch (Exception e) {
            LOGGER.error("");
            return 0;
        }
    }

    public static String[] getNumberArray(int start, int end, int increment) {
        if (increment > 0) {
            int count = (end - start) / increment;
            String[] numbers = new String[count];
            for (int i = 0; i < count; ++i) {
                numbers[i] = String.valueOf(start + i * increment);
            }
            return numbers;
        }
        return new String[0];
    }

    public static <T> List<T[]> arraySplit(T[] original, int splitSize) {
        ArrayList<T[]> result = new ArrayList<T[]>();
        if (original == null) {
            return result;
        }
        for (int currentPosition = 0; currentPosition < original.length; currentPosition += splitSize) {
            int remaining = original.length - currentPosition + 1;
            if (remaining <= splitSize) {
                result.add(Arrays.copyOfRange(original, currentPosition, original.length));
                continue;
            }
            result.add(Arrays.copyOfRange(original, currentPosition, currentPosition + splitSize));
        }
        return result;
    }

    public static <T> List<List<T>> collectionSplit(List original, int splitSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        if (original == null) {
            return result;
        }
        for (int currentPosition = 0; currentPosition < original.size(); currentPosition += splitSize) {
            int remaining = original.size() - currentPosition + 1;
            if (remaining <= splitSize) {
                result.add(new ArrayList<Object>(List.of(Arrays.copyOfRange(original.toArray(), currentPosition, original.size()))));
                continue;
            }
            result.add(new ArrayList<Object>(List.of(Arrays.copyOfRange(original.toArray(), currentPosition, currentPosition + splitSize))));
        }
        return result;
    }

    public static List<Long> getLongList(Collection<String> nums) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (nums != null) {
            for (String num : nums) {
                ids.add(Long.valueOf(num));
            }
        }
        return ids;
    }

    public static List<Long> getLongList(String ... nums) {
        return OsUtils.getLongList(List.of(nums));
    }
}

