/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.AssertionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    public static final MethodFilter USER_DECLARED_METHODS = method -> !method.isBridge() && !method.isSynthetic();
    public static final FieldFilter COPYABLE_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final String UNACCEPTABLE_NULL_CLAZZ = "null clazz not acceptable";
    private static final String UNACCEPTABLE_FIELD_PATH = "null or empty field path not acceptable";
    private static final String CGLIB_RENAMED_METHOD_PREFIX = "CGLIB$";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private ReflectionUtils() {
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error("can't instantiate class using empty constructor {}", clazz, (Object)e);
            throw new IllegalArgumentException("can't instantiate class using empty constructor" + clazz, e);
        }
    }

    public static <T> Class<T> getGenericArgType(Class<?> clazz, int genericArgIndex) {
        Class<?> targetClazz = clazz;
        ParameterizedType parameterizedType = null;
        while (null == parameterizedType && null != targetClazz.getGenericSuperclass()) {
            if (targetClazz.getGenericSuperclass() instanceof ParameterizedType && ((ParameterizedType)targetClazz.getGenericSuperclass()).getActualTypeArguments().length >= genericArgIndex + 1) {
                parameterizedType = (ParameterizedType)targetClazz.getGenericSuperclass();
                continue;
            }
            targetClazz = targetClazz.getSuperclass();
        }
        if (null == parameterizedType) {
            throw new IllegalArgumentException("can't determine generic arg class at index: " + genericArgIndex + " for class: " + clazz);
        }
        try {
            Type type = ((ParameterizedType)targetClazz.getGenericSuperclass()).getActualTypeArguments()[genericArgIndex];
            if (type instanceof Class) {
                return (Class)type;
            }
            throw new IllegalArgumentException("can't determine class from generic type!");
        }
        catch (Exception e) {
            LOGGER.debug("can't determine class from generic type, at index [{}]", (Object)genericArgIndex, (Object)e);
            throw new IllegalArgumentException("can't determine class from generic type!", e);
        }
    }

    public static Field findField(Class<?> type, final FieldFilter filter) {
        return ReflectionUtils.findField(type, new DescribedFieldFilter(){

            @Override
            public boolean matches(Field field) {
                return filter.matches(field);
            }

            @Override
            public String getDescription() {
                return String.format("FieldFilter %s", filter.toString());
            }
        }, false);
    }

    public static Field findField(Class<?> type, DescribedFieldFilter filter) {
        return ReflectionUtils.findField(type, filter, true);
    }

    public static Field findField(Class<?> type, DescribedFieldFilter filter, boolean enforceUniqueness) {
        AssertionUtils.notNull(type, "Type must not be null!");
        AssertionUtils.notNull((Object)filter, "Filter must not be null!");
        Field foundField = null;
        for (Class<?> targetClass = type; targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!filter.matches(field)) continue;
                if (!enforceUniqueness) {
                    return field;
                }
                if (foundField != null) {
                    throw new IllegalStateException(filter.getDescription());
                }
                foundField = field;
            }
        }
        return foundField;
    }

    public static Field findRequiredField(Class<?> type, String name) {
        Field result = ReflectionUtils.findField(type, name);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Unable to find field %s on %s!", name, type));
        }
        return result;
    }

    public static Method findRequiredMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        Method result = ReflectionUtils.findMethod(type, name, parameterTypes);
        if (result == null) {
            String parameterTypeNames = Arrays.stream(parameterTypes).map(Object::toString).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Unable to find method %s(%s)on %s!", name, parameterTypeNames, type));
        }
        return result;
    }

    public static Stream<Class<?>> returnTypeAndParameters(Method method) {
        AssertionUtils.notNull((Object)method, "Method must not be null!");
        Stream<Class<?>> returnType = Stream.of(method.getReturnType());
        Stream<Class<?>> parameterTypes = Arrays.stream(method.getParameterTypes());
        return Stream.concat(returnType, parameterTypes);
    }

    public static Object getPrimitiveDefault(Class<?> type) {
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)0;
        }
        if (type == Short.TYPE || type == Short.class) {
            return (short)0;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 0;
        }
        if (type == Long.TYPE || type == Long.class) {
            return 0L;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE || type == Double.class) {
            return 0.0;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException(String.format("Primitive type %s not supported!", type));
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (Object.class != clazz.getSuperclass()) {
                return ReflectionUtils.getDeclaredField(clazz.getSuperclass(), name);
            }
            throw e;
        }
    }

    public static Object getPropertyValue(Object root, String propertyPath) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String[] properties;
        if (root == null) {
            throw new IllegalArgumentException("null object not acceptable");
        }
        if (propertyPath == null || propertyPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty what not acceptable");
        }
        Object current = root;
        for (String property : properties = propertyPath.split("\\.")) {
            if (current == null) {
                return null;
            }
            current = ReflectionUtils.getGetter(current.getClass(), property).invoke(current, new Object[0]);
        }
        return current;
    }

    public static Field getField(Class<?> clazz, String fieldPath) {
        if (clazz == null) {
            throw new IllegalArgumentException(UNACCEPTABLE_NULL_CLAZZ);
        }
        if (StringUtils.isBlank((CharSequence)fieldPath)) {
            throw new IllegalArgumentException(UNACCEPTABLE_FIELD_PATH);
        }
        Class<?> currentClazz = clazz;
        String[] fieldPaths = fieldPath.split("\\.");
        Field field = null;
        for (String fieldName : fieldPaths) {
            field = ReflectionUtils.findField(currentClazz, fieldName);
            if (null == field) {
                return null;
            }
            currentClazz = field.getType();
        }
        return field;
    }

    public static Class<?> getContainerCLassByField(Class<?> clazz, String fieldPath) {
        if (clazz == null) {
            throw new IllegalArgumentException(UNACCEPTABLE_NULL_CLAZZ);
        }
        if (StringUtils.isBlank((CharSequence)fieldPath)) {
            throw new IllegalArgumentException(UNACCEPTABLE_FIELD_PATH);
        }
        Class<?> currentClazz = clazz;
        String[] fieldPaths = fieldPath.split("\\.");
        for (int i = 0; i < fieldPaths.length - 1; ++i) {
            currentClazz = ReflectionUtils.findField(currentClazz, fieldPaths[i]).getType();
        }
        return currentClazz;
    }

    public static Method getGetterMethod(Class<?> clazz, String fieldPath) throws NoSuchMethodException {
        if (clazz == null) {
            throw new IllegalArgumentException(UNACCEPTABLE_NULL_CLAZZ);
        }
        if (StringUtils.isBlank((CharSequence)fieldPath)) {
            throw new IllegalArgumentException(UNACCEPTABLE_FIELD_PATH);
        }
        Class<?> currentClazz = clazz;
        String[] fieldPaths = fieldPath.split("\\.");
        Method method = null;
        for (String fieldName : fieldPaths) {
            method = ReflectionUtils.getGetter(currentClazz, fieldName);
            currentClazz = method.getReturnType();
        }
        return method;
    }

    public static Class<?> getContainerClassByGetter(Class<?> clazz, String fieldPath) throws NoSuchMethodException {
        if (clazz == null) {
            throw new IllegalArgumentException(UNACCEPTABLE_NULL_CLAZZ);
        }
        if (StringUtils.isBlank((CharSequence)fieldPath)) {
            throw new IllegalArgumentException(UNACCEPTABLE_FIELD_PATH);
        }
        Class<?> currentClazz = clazz;
        String[] fieldPaths = fieldPath.split("\\.");
        for (int i = 0; i < fieldPaths.length - 1; ++i) {
            currentClazz = ReflectionUtils.getGetter(currentClazz, fieldPaths[i]).getReturnType();
        }
        return currentClazz;
    }

    public static Object setValue(Object root, String path, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        if (root == null) {
            throw new IllegalArgumentException("null root not acceptable");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("null or empty what not acceptable");
        }
        if (null == value) {
            return root;
        }
        Object current = root;
        String[] callList = path.split("\\.");
        for (int i = 0; i < callList.length - 1; ++i) {
            Method getter = ReflectionUtils.getGetter(current.getClass(), callList[i]);
            Object result = getter.invoke(current, new Object[0]);
            if (result == null) {
                result = getter.getReturnType().getConstructor(new Class[0]).newInstance(new Object[0]);
                ReflectionUtils.getSetter(current.getClass(), callList[i], result.getClass()).invoke(current, result);
            }
            current = result;
        }
        try {
            ReflectionUtils.getSetter(current.getClass(), callList[callList.length - 1], value.getClass()).invoke(current, value);
        }
        catch (NoSuchMethodException e) {
            Class<Number> clazz;
            if (value.getClass().equals(Byte.class)) {
                clazz = Byte.TYPE;
            } else if (value.getClass().equals(Short.class)) {
                clazz = Short.TYPE;
            } else if (value.getClass().equals(Integer.class)) {
                clazz = Integer.TYPE;
            } else if (value.getClass().equals(Long.class)) {
                clazz = Long.TYPE;
            } else {
                throw e;
            }
            ReflectionUtils.getSetter(current.getClass(), callList[callList.length - 1], clazz).invoke(current, value);
        }
        return current;
    }

    public static Method getSetter(Class<?> aClass, String property, Class<?> ... parameterType) throws NoSuchMethodException {
        if (aClass == null) {
            throw new IllegalArgumentException("null _class not accepted");
        }
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("null or empty property not accepted");
        }
        return aClass.getMethod(ReflectionUtils.getSetterName(property.trim()), parameterType);
    }

    public static Method getGetter(Class<?> aClass, String property) throws NoSuchMethodException {
        if (aClass == null) {
            throw new IllegalArgumentException("null _class not accepted");
        }
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("null or empty property not accepted");
        }
        try {
            return aClass.getMethod(ReflectionUtils.getGetterName(property.trim(), String.class), new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            return aClass.getMethod(ReflectionUtils.getGetterName(property.trim(), Boolean.TYPE), new Class[0]);
        }
    }

    public static Method getCurrentMethod(StackTraceElement stackTraceElement) throws ClassNotFoundException, NoSuchMethodException {
        return Class.forName(stackTraceElement.getClassName()).getMethod(stackTraceElement.getMethodName(), new Class[0]);
    }

    public static String getGetterName(String property, Class<?> type) {
        property = property.trim();
        return (Boolean.TYPE.equals(type) || Boolean.class.equals(type) ? "is" : "get") + property.substring(0, 1).toUpperCase() + property.substring(1);
    }

    public static String getSetterName(String property) {
        return "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
    }

    public static <T extends Annotation> Map<Field, T> getFieldAnnotationMap(Class<?> clazz, Class<T> annotationClazz, boolean includeSuperClasses) {
        HashMap<Field, T> map = new HashMap<Field, T>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClazz)) continue;
            map.put(field, field.getAnnotation(annotationClazz));
        }
        if (includeSuperClasses && !Object.class.equals(clazz.getSuperclass())) {
            map.putAll(ReflectionUtils.getFieldAnnotationMap(clazz.getSuperclass(), annotationClazz, true));
        }
        return map;
    }

    public static <T extends Annotation> List<Field> getFields(Class<?> clazz, Class<T> annotationClazz, boolean includeSuperClasses) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClazz)) continue;
            fields.add(field);
        }
        if (includeSuperClasses && !Object.class.equals(clazz.getSuperclass())) {
            fields.addAll(ReflectionUtils.getFields(clazz.getSuperclass(), annotationClazz, true));
        }
        return fields;
    }

    public static Set<String> fetchPropertyFields(Set<String> allFields, String fieldName) {
        AssertionUtils.notNull((Object)fieldName, "null field name not acceptable");
        HashSet<String> fields = new HashSet<String>();
        if (null == allFields) {
            return fields;
        }
        allFields.forEach(field -> {
            if (field.startsWith(fieldName + ".")) {
                fields.add(field.replaceFirst(fieldName + ".", ""));
            }
        });
        if (!fields.isEmpty()) {
            fields.add(fieldName);
        }
        return fields;
    }

    public static boolean isContainField(Set<String> fields, String fieldName) {
        AssertionUtils.notNull((Object)fieldName, "null field name not acceptable");
        if (null == fields) {
            return false;
        }
        for (String field : fields) {
            if (!field.equals(fieldName) && !field.startsWith(fieldName + ".")) continue;
            return true;
        }
        return false;
    }

    public static String methodToFieldName(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.replaceFirst("get", "");
        } else if (name.startsWith("is")) {
            name = name.replaceFirst("is", "");
        }
        return ReflectionUtils.lowerCaseFirstLetter(name);
    }

    public static String lowerCaseFirstLetter(String name) {
        StringBuilder builder = new StringBuilder(name);
        builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
        return builder.toString();
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static <T> Constructor<T> accessibleConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<T> ctor = clazz.getDeclaredConstructor(parameterTypes);
        ReflectionUtils.makeAccessible(ctor);
        return ctor;
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, EMPTY_CLASS_ARRAY);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        AssertionUtils.notNull(clazz, "Class must not be null");
        AssertionUtils.notNull((Object)name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType, false)) {
                if (!name.equals(method.getName()) || paramTypes != null && !ReflectionUtils.hasSameParams(method, paramTypes)) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        return paramTypes.length == method.getParameterCount() && Arrays.equals(paramTypes, method.getParameterTypes());
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod(method, target, EMPTY_OBJECT_ARRAY);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        AssertionUtils.notNull((Object)method, "Method must not be null");
        for (Class<?> declaredException : declaredExceptions = method.getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static void doWithLocalMethods(Class<?> clazz, MethodCallback mc) {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getDeclaredMethods(clazz, false)) {
            mc.doWith(method);
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) {
        ReflectionUtils.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, MethodFilter mf) {
        Method[] methods = ReflectionUtils.getDeclaredMethods(clazz, false);
        for (Method method : methods) {
            if (mf != null && !mf.matches(method)) continue;
            mc.doWith(method);
        }
        if (clazz.getSuperclass() != null && (mf != USER_DECLARED_METHODS || clazz.getSuperclass() != Object.class)) {
            ReflectionUtils.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionUtils.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        ArrayList methods = new ArrayList(32);
        ReflectionUtils.doWithMethods(leafClass, methods::add);
        return methods.toArray(EMPTY_METHOD_ARRAY);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) {
        return ReflectionUtils.getUniqueDeclaredMethods(leafClass, null);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass, MethodFilter mf) {
        ArrayList methods = new ArrayList(32);
        ReflectionUtils.doWithMethods(leafClass, method -> {
            boolean knownSignature = false;
            Method methodBeingOverriddenWithCovariantReturnType = null;
            for (Method existingMethod : methods) {
                if (!method.getName().equals(existingMethod.getName()) || method.getParameterCount() != existingMethod.getParameterCount() || !Arrays.equals(method.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                if (existingMethod.getReturnType() != method.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                    methodBeingOverriddenWithCovariantReturnType = existingMethod;
                    break;
                }
                knownSignature = true;
                break;
            }
            if (methodBeingOverriddenWithCovariantReturnType != null) {
                methods.remove(methodBeingOverriddenWithCovariantReturnType);
            }
            if (!knownSignature && !ReflectionUtils.isCglibRenamedMethod(method)) {
                methods.add(method);
            }
        }, mf);
        return methods.toArray(EMPTY_METHOD_ARRAY);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return ReflectionUtils.getDeclaredMethods(clazz, true);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz, boolean defensive) {
        Method[] result;
        AssertionUtils.notNull(clazz, "Class must not be null");
        try {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            List<Method> defaultMethods = ReflectionUtils.findConcreteMethodsOnInterfaces(clazz);
            if (defaultMethods != null) {
                result = new Method[declaredMethods.length + defaultMethods.size()];
                System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                int index = declaredMethods.length;
                Iterator<Method> iterator = defaultMethods.iterator();
                while (iterator.hasNext()) {
                    Method defaultMethod;
                    result[index] = defaultMethod = iterator.next();
                    ++index;
                }
            } else {
                result = declaredMethods;
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
        }
        return result.length == 0 || !defensive ? result : (Method[])result.clone();
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        if (method.getParameterCount() != 1) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterCount() == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterCount() == 0;
    }

    public static boolean isObjectMethod(Method method) {
        return method != null && (method.getDeclaringClass() == Object.class || ReflectionUtils.isEqualsMethod(method) || ReflectionUtils.isHashCodeMethod(method) || ReflectionUtils.isToStringMethod(method));
    }

    public static boolean isCglibRenamedMethod(Method renamedMethod) {
        String name = renamedMethod.getName();
        if (name.startsWith(CGLIB_RENAMED_METHOD_PREFIX)) {
            int i;
            for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
            }
            return i > CGLIB_RENAMED_METHOD_PREFIX.length() && i < name.length() - 1 && name.charAt(i) == '$';
        }
        return false;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        AssertionUtils.notNull(clazz, "Class must not be null");
        AssertionUtils.isTrue(name != null || type != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectionUtils.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
    }

    public static Object getField(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void doWithLocalFields(Class<?> clazz, FieldCallback fc) {
        for (Field field : ReflectionUtils.getDeclaredFields(clazz)) {
            try {
                fc.doWith(field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) {
        ReflectionUtils.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, FieldFilter ff) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = ReflectionUtils.getDeclaredFields(targetClass)) {
                if (ff != null && !ff.matches(field)) continue;
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Field[] result;
        AssertionUtils.notNull(clazz, "Class must not be null");
        try {
            result = clazz.getDeclaredFields();
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
        }
        return result;
    }

    public static void shallowCopyFieldState(Object src, Object dest) {
        AssertionUtils.notNull(src, "Source for field copy cannot be null");
        AssertionUtils.notNull(dest, "Destination for field copy cannot be null");
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(src.getClass(), field -> {
            ReflectionUtils.makeAccessible(field);
            Object srcValue = field.get(src);
            field.set(dest, srcValue);
        }, COPYABLE_FIELDS);
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static <T> Set<Class<? extends T>> getSubTypeOf(String packagePrefix, Class<T> clazz) {
        return new Reflections(packagePrefix, new Scanner[]{Scanners.SubTypes}).getSubTypesOf(clazz);
    }

    public static List<Class<?>> getSupersOf(Class<?> clazz, boolean includeInterface, boolean includeAbstractClasses, boolean includeObjectClass) {
        Class<?> parent;
        ArrayList supers = new ArrayList();
        if (null == clazz || clazz.equals(Object.class)) {
            return supers;
        }
        if (includeObjectClass) {
            supers.add(Object.class);
        }
        if (null != (parent = clazz.getSuperclass()) && !Object.class.equals(parent)) {
            if (Modifier.isAbstract(parent.getModifiers())) {
                if (includeAbstractClasses) {
                    supers.add(parent);
                }
            } else {
                supers.add(parent);
            }
            supers.addAll(ReflectionUtils.getSupersOf(parent, includeInterface, includeAbstractClasses, false));
        }
        if (includeInterface) {
            for (Class<?> anInterface : clazz.getInterfaces()) {
                supers.add(anInterface);
                supers.addAll(ReflectionUtils.getSupersOf(anInterface, true, includeAbstractClasses, false));
            }
        }
        return supers;
    }

    @FunctionalInterface
    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface DescribedFieldFilter
    extends FieldFilter {
        public String getDescription();
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException;
    }

    @FunctionalInterface
    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

