/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpCallRequest {
    private String httpMethod;
    private String urlTemplate;
    private String bodyTemplate;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public String getHeader(String name) {
        return this.headers.get(name).get(0);
    }

    public HttpCallRequest httpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public HttpCallRequest urlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        return this;
    }

    public HttpCallRequest bodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
        return this;
    }

    public HttpCallRequest headers(String name, List<String> values) {
        this.headers.putIfAbsent(name, new ArrayList());
        this.headers.get(name).addAll(values);
        return this;
    }

    public HttpCallRequest header(String name, String value) {
        this.headers.putIfAbsent(name, new ArrayList());
        this.headers.get(name).add(value);
        return this;
    }

    public HttpCallRequest headers(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public void setBodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public String toString() {
        return "HttpCallRequest(httpMethod=" + this.getHttpMethod() + ", urlTemplate=" + this.getUrlTemplate() + ", bodyTemplate=" + this.getBodyTemplate() + ", headers=" + String.valueOf(this.getHeaders()) + ")";
    }
}

