/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.http;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpCallResponse {
    private final int statusCode;
    private final byte[] body;
    private final byte[] error;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public String getHeader(String name) {
        return this.headers.get(name).get(0);
    }

    public String getContentType() {
        return this.headers.get("Content-Type").get(0);
    }

    public String getBodyAsString() {
        return null == this.error ? null : new String(this.error);
    }

    public String getErrorAsString() {
        return null == this.error ? null : new String(this.error);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getBody() {
        return this.body;
    }

    public byte[] getError() {
        return this.error;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public String toString() {
        return "HttpCallResponse(statusCode=" + this.getStatusCode() + ", body=" + Arrays.toString(this.getBody()) + ", error=" + Arrays.toString(this.getError()) + ", headers=" + String.valueOf(this.getHeaders()) + ")";
    }

    public HttpCallResponse(int statusCode, byte[] body, byte[] error, Map<String, List<String>> headers) {
        this.statusCode = statusCode;
        this.body = body;
        this.error = error;
        this.headers = headers;
    }
}

