/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.http;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bardframework.commons.utils.http.HttpCallResponse;
import org.bardframework.commons.utils.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCaller {
    private static final Logger log = LoggerFactory.getLogger(HttpCaller.class);
    protected final String httpMethod;
    protected final String urlTemplate;
    protected String bodyTemplate;
    protected int connectTimeoutSeconds = 30;
    protected int readTimeoutSeconds = 3600;
    protected boolean logResponse;
    protected boolean disable;
    protected Map<String, String> headers = new HashMap<String, String>();

    public HttpCaller(String httpMethod, String urlTemplate) {
        this.httpMethod = httpMethod;
        this.urlTemplate = urlTemplate;
    }

    public HttpCallResponse call(Map<String, String> args) throws IOException {
        return this.call(this.getHeaders(), args);
    }

    public HttpCallResponse call(Map<String, String> headers, Map<String, String> args) throws IOException {
        if (this.isDisable()) {
            log.error("[{}] is disable.", (Object)this.getClass().getSimpleName());
            return new HttpCallResponse(-1, new byte[0], new byte[0], Map.of());
        }
        HttpCallResponse callResult = HttpUtils.httpCall(this.getHttpMethod(), this.getUrlTemplate(), this.getBodyTemplate(), this.getConnectTimeoutSeconds(), this.getReadTimeoutSeconds(), headers, args);
        if (this.isLogResponse()) {
            log.info("calling url[{}], response code: [{}], response body: [{}]", new Object[]{this.getUrlTemplate(), callResult.getStatusCode(), new String(callResult.getBody(), StandardCharsets.UTF_8)});
        }
        return callResult;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public boolean isLogResponse() {
        return this.logResponse;
    }

    public boolean isDisable() {
        return this.disable;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setBodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    public void setLogResponse(boolean logResponse) {
        this.logResponse = logResponse;
    }

    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

