/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import lombok.Generated;

public final class SerializationUtils {
    public static byte[] serialize(Serializable object) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SerializationUtils.serialize(object, outputStream);
        return outputStream.toByteArray();
    }

    public static void serialize(Serializable object, OutputStream outputStream) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(outputStream);){
            out.writeObject(object);
        }
    }

    public static <T> T deserialize(byte[] inBytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(inBytes);
        return SerializationUtils.deserialize(inputStream);
    }

    public static <T> T deserialize(InputStream inputStream) throws IOException, ClassNotFoundException {
        try (ObjectInputStream in = new ObjectInputStream(inputStream);){
            Object object = in.readObject();
            return (T)object;
        }
    }

    public static byte[] serializeAndEncodeObject(Serializable obj) throws IOException {
        return SerializationUtils.serialize(obj);
    }

    public static <T> T deserializeAndCheckObject(byte[] object, Class<?> type) throws IOException, ClassNotFoundException {
        T result = SerializationUtils.deserialize(object);
        if (!type.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Decoded object is of type " + String.valueOf(result.getClass()) + " when we were expecting " + String.valueOf(type));
        }
        return result;
    }

    @Generated
    private SerializationUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

