/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.http;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bardframework.commons.utils.http.HttpCallResponse;
import org.bardframework.commons.utils.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCaller {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpCaller.class);
    protected String httpMethod;
    protected String urlTemplate;
    protected String bodyTemplate;
    protected int connectTimeoutSeconds = 30;
    protected int readTimeoutSeconds = 3600;
    protected boolean logResponse;
    protected boolean disable;
    protected Map<String, String> headers = new HashMap<String, String>();

    public HttpCaller() {
    }

    public HttpCaller(String httpMethod, String urlTemplate) {
        this.httpMethod = httpMethod;
        this.urlTemplate = urlTemplate;
    }

    public HttpCallResponse call(Map<String, Object> args) throws IOException {
        return this.call(this.getHeaders(), args);
    }

    public HttpCallResponse call(Map<String, String> headers, Map<String, Object> args) throws IOException {
        if (this.isDisable()) {
            log.error("[{}] is disable.", (Object)this.getClass().getSimpleName());
            return new HttpCallResponse(-1, new byte[0], new byte[0]);
        }
        HashMap<String, String> allArgs = new HashMap<String, String>();
        args.forEach((key, value) -> allArgs.put((String)key, value.toString()));
        this.getDefaultArgs().forEach((key, value) -> allArgs.put((String)key, value.toString()));
        HttpCallResponse callResult = HttpUtils.httpCall(this.getHttpMethod(), this.getUrlTemplate(), this.getBodyTemplate(), this.getConnectTimeoutSeconds(), this.getReadTimeoutSeconds(), headers, allArgs);
        if (this.isLogResponse()) {
            log.info("calling url[{}], response code: [{}], response body: [{}]", new Object[]{this.getUrlTemplate(), callResult.getStatusCode(), new String(callResult.getBody(), StandardCharsets.UTF_8)});
        }
        return callResult;
    }

    protected Map<String, Object> getDefaultArgs() {
        return Map.of();
    }

    @Generated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    @Generated
    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    @Generated
    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    @Generated
    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    @Generated
    public boolean isLogResponse() {
        return this.logResponse;
    }

    @Generated
    public boolean isDisable() {
        return this.disable;
    }

    @Generated
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Generated
    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Generated
    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    @Generated
    public void setBodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
    }

    @Generated
    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Generated
    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    @Generated
    public void setLogResponse(boolean logResponse) {
        this.logResponse = logResponse;
    }

    @Generated
    public void setDisable(boolean disable) {
        this.disable = disable;
    }

    @Generated
    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }
}

