/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import lombok.Generated;
import org.bardframework.commons.utils.EncodingUtils;

public final class DigestUtils {
    private static final String SHA512 = "SHA512";
    private static final String SHA = "SHA";

    public static String sha512(String data) throws NoSuchAlgorithmException {
        return DigestUtils.digest(SHA512, data.getBytes(StandardCharsets.UTF_8));
    }

    public static String sha(String data) throws NoSuchAlgorithmException {
        return DigestUtils.digest(SHA, data);
    }

    public static byte[] sha(byte[] data) throws NoSuchAlgorithmException {
        return DigestUtils.rawDigest(SHA, data);
    }

    public static String digest(String alg, String data) throws NoSuchAlgorithmException {
        return DigestUtils.digest(alg, data.getBytes(StandardCharsets.UTF_8));
    }

    public static String digest(String alg, byte[] data) throws NoSuchAlgorithmException {
        return EncodingUtils.hexEncode(DigestUtils.rawDigest(alg, data));
    }

    public static byte[] rawDigest(String alg, byte[] data) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(alg).digest(data);
    }

    @Generated
    private DigestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

