/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class HttpCallRequest {
    private String httpMethod;
    private String urlTemplate;
    private String bodyTemplate;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public String getHeader(String name) {
        return this.headers.get(name).get(0);
    }

    public HttpCallRequest httpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public HttpCallRequest urlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        return this;
    }

    public HttpCallRequest bodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
        return this;
    }

    public HttpCallRequest headers(String name, List<String> values) {
        this.headers.putIfAbsent(name, new ArrayList());
        this.headers.get(name).addAll(values);
        return this;
    }

    public HttpCallRequest header(String name, String value) {
        this.headers.putIfAbsent(name, new ArrayList());
        this.headers.get(name).add(value);
        return this;
    }

    public HttpCallRequest headers(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    @Generated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    @Generated
    public String getBodyTemplate() {
        return this.bodyTemplate;
    }

    @Generated
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Generated
    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Generated
    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    @Generated
    public void setBodyTemplate(String bodyTemplate) {
        this.bodyTemplate = bodyTemplate;
    }

    @Generated
    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Generated
    public String toString() {
        return "HttpCallRequest(httpMethod=" + this.getHttpMethod() + ", urlTemplate=" + this.getUrlTemplate() + ", bodyTemplate=" + this.getBodyTemplate() + ", headers=" + String.valueOf(this.getHeaders()) + ")";
    }
}

