/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.StringTemplateUtils;
import org.bardframework.commons.utils.UrlUtils;
import org.bardframework.commons.utils.http.HttpCallRequest;
import org.bardframework.commons.utils.http.HttpCallResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static HttpCallResponse httpCall(String httpMethod, String urlTemplate, String bodyTemplate, int connectTimeoutSeconds, int readTimeoutSeconds, Map<String, String> headers, Map<String, String> args) throws IOException {
        HashedMap multiValueHeaders = new HashedMap();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            multiValueHeaders.put(entry.getKey(), List.of(entry.getValue()));
        }
        HttpCallRequest request = new HttpCallRequest().httpMethod(httpMethod).urlTemplate(urlTemplate).bodyTemplate(bodyTemplate).headers((Map<String, List<String>>)multiValueHeaders);
        return HttpUtils.httpCall(request, connectTimeoutSeconds, readTimeoutSeconds, args);
    }

    public static HttpCallResponse httpCall(HttpCallRequest request, int connectTimeoutSeconds, int readTimeoutSeconds, Map<String, String> args) throws IOException {
        String url = UrlUtils.fillUrlTemplate(request.getUrlTemplate(), args);
        String body = null;
        if (StringUtils.isNotBlank((CharSequence)request.getBodyTemplate())) {
            body = StringTemplateUtils.fillTemplate(request.getBodyTemplate(), args);
        }
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (MapUtils.isNotEmpty(request.getHeaders())) {
            for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
                for (String valueTemplate : entry.getValue()) {
                    String headerKey = StringTemplateUtils.fillTemplate(entry.getKey(), args);
                    String headerValue = StringTemplateUtils.fillTemplate(valueTemplate, args);
                    headers.put(headerKey, new ArrayList());
                    ((List)headers.get(headerKey)).add(headerValue);
                }
            }
        }
        return HttpUtils.httpCall(request.getHttpMethod(), url, null == body ? null : body.getBytes(), headers, connectTimeoutSeconds, readTimeoutSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpCallResponse httpCall(String httpMethod, String url, byte[] body, Map<String, List<String>> headers, int connectTimeoutSeconds, int readTimeoutSeconds) throws IOException {
        if (StringUtils.isBlank((CharSequence)httpMethod)) {
            throw new IllegalStateException("empty http method not acceptable");
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalStateException("empty url not acceptable");
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)URI.create(url).toURL().openConnection();
            connection.setRequestMethod(httpMethod);
            connection.setConnectTimeout(connectTimeoutSeconds * 1000);
            connection.setReadTimeout(readTimeoutSeconds * 1000);
            if (MapUtils.isNotEmpty(headers)) {
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    if (StringUtils.isBlank((CharSequence)entry.getKey())) {
                        throw new IllegalArgumentException("empty header name not acceptable: " + entry.getKey());
                    }
                    for (String value : entry.getValue()) {
                        if (StringUtils.isBlank((CharSequence)value)) {
                            throw new IllegalArgumentException("empty header value not acceptable: " + entry.getKey());
                        }
                        connection.setRequestProperty(entry.getKey(), value);
                    }
                }
            }
            if (null != body) {
                log.debug("setting request body, http method [{}] ", (Object)httpMethod);
                connection.setDoOutput(true);
                try (OutputStream outputStream = connection.getOutputStream();){
                    outputStream.write(body);
                }
            }
            int responseCode = connection.getResponseCode();
            InputStream errorStream = null;
            try {
                errorStream = connection.getErrorStream();
            }
            catch (Exception e) {
                log.trace("error reading error stream of calling url: [{}]", (Object)url, (Object)e);
            }
            InputStream responseStream = null;
            try {
                responseStream = connection.getInputStream();
            }
            catch (Exception e) {
                log.trace("error reading response stream of calling url: [{}]", (Object)url, (Object)e);
            }
            byte[] response = null == responseStream ? new byte[]{} : IOUtils.toByteArray((InputStream)responseStream);
            byte[] error = null == errorStream ? new byte[]{} : IOUtils.toByteArray((InputStream)errorStream);
            log.trace("http call[{}] response, code: [{}], details: [{}]", new Object[]{url, responseCode, IOUtils.toString((byte[])response, (String)StandardCharsets.UTF_8.displayName())});
            HttpCallResponse callResponse = new HttpCallResponse(responseCode, response, error);
            callResponse.setHeaders(connection.getHeaderFields());
            callResponse.setUrl(url);
            HttpCallResponse httpCallResponse = callResponse;
            return httpCallResponse;
        }
        finally {
            if (null != connection) {
                connection.disconnect();
            }
        }
    }

    @Generated
    private HttpUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

