/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimeUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DateTimeUtils.class);
    public static final long ONE_SECOND_MILLS = 1000L;
    public static final long ONE_MINUTE_MILLS = 60000L;
    public static final long ONE_HOUR_MILLS = 3600000L;
    public static final long ONE_DAY_MILLS = 86400000L;
    public static final long ONE_WEEK_MILLS = 604800000L;
    public static final long ONE_MONTH_MILLS = 2592000000L;
    public static final long ONE_YEAR_MILLS = 31104000000L;

    public static long getNowUtc() {
        return Instant.now().toEpochMilli();
    }

    public static long getTodayUtc() {
        return Instant.now().truncatedTo(ChronoUnit.DAYS).toEpochMilli();
    }

    public static long toEpochMills(LocalDateTime dateTime) {
        return DateTimeUtils.toEpochMills(dateTime, ZoneOffset.UTC);
    }

    public static long toEpochMills(LocalDateTime dateTime, ZoneOffset offset) {
        return dateTime.toInstant(offset).toEpochMilli();
    }

    public static LocalDateTime fromEpochMills(long dateTimeAsMills) {
        return DateTimeUtils.fromEpochMills(dateTimeAsMills, ZoneOffset.UTC);
    }

    public static LocalDate dateFromEpochMills(long dateAsMills) {
        return Instant.ofEpochMilli(dateAsMills).atZone(ZoneOffset.UTC).toLocalDate();
    }

    public static LocalDateTime fromEpochMills(long dateTimeAsMills, ZoneId zone) {
        if (null == zone) {
            throw new IllegalArgumentException("null zone not acceptable.");
        }
        return Instant.ofEpochMilli(dateTimeAsMills).atZone(zone).toLocalDateTime();
    }

    public static long diffDays(long startDateEpochMills, long endDateEpochMills) {
        return ChronoUnit.DAYS.between(DateTimeUtils.fromEpochMills(startDateEpochMills), DateTimeUtils.fromEpochMills(endDateEpochMills));
    }

    public static long leftDays(long startDateEpochMills) {
        return ChronoUnit.DAYS.between(DateTimeUtils.fromEpochMills(startDateEpochMills), LocalDateTime.now());
    }

    public static long remainDays(long endDateEpochMills) {
        return ChronoUnit.DAYS.between(LocalDateTime.now(), DateTimeUtils.fromEpochMills(endDateEpochMills));
    }

    public static long toEpochMills(LocalDate date) {
        if (null == date) {
            throw new IllegalArgumentException("null date not acceptable.");
        }
        return date.toEpochDay() * 24L * 60L * 60L * 1000L;
    }

    @Generated
    private DateTimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

