/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.utils;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.utils.StringTemplateUtils;

public final class UrlUtils {
    public static String makeCleanUrl(String ... parts) {
        if (null == parts) {
            throw new IllegalArgumentException("null string array not acceptable");
        }
        StringBuilder all = new StringBuilder();
        for (String part : parts) {
            if (!StringUtils.isNotBlank((CharSequence)part)) continue;
            all.append(part);
            all.append('/');
        }
        String url = all.toString().replaceFirst("://", "%%%%");
        while (url.contains("//")) {
            url = url.replace("//", "/");
        }
        url = StringUtils.removeEnd((String)url, (String)"/");
        url = StringUtils.removeStart((String)url, (String)"/");
        return url.replaceFirst("%%%%", "://").replaceFirst("///", "//");
    }

    public static String urlEncode(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        return URLEncoder.encode(value, StandardCharsets.UTF_8);
    }

    public static String fillUrlTemplate(String urlTemplate, Map<String, ?> args) {
        return StringTemplateUtils.fillTemplate(urlTemplate, UrlUtils.urlEncodeValues(args));
    }

    public static String fillUrlTemplate(String urlTemplate, String prefix, String suffix, Map<String, Object> args) {
        return StringTemplateUtils.fillTemplate(urlTemplate, prefix, suffix, UrlUtils.urlEncodeValues(args));
    }

    public static Map<String, String> urlEncodeValues(Map<String, ?> args) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : args.entrySet()) {
            String value = StringTemplateUtils.fillTemplate(entry.getValue().toString(), args);
            map.put(entry.getKey(), UrlUtils.urlEncode(value));
        }
        return map;
    }

    @Generated
    private UrlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

