/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.waf;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bardframework.commons.waf.RequestLimitChecker;
import org.bardframework.commons.waf.exception.CallLimitExceedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class WafFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WafFilter.class);
    private final List<RequestLimitChecker> checkers;

    public WafFilter(List<RequestLimitChecker> checkers) {
        this.checkers = checkers;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            for (RequestLimitChecker checker : this.checkers) {
                if (!checker.match((HttpServletRequest)request)) continue;
                checker.checkCallLimit((HttpServletRequest)request, (HttpServletResponse)response);
            }
            chain.doFilter(request, response);
        }
        catch (CallLimitExceedException e) {
            LOGGER.warn("call limit exceed for [{}]", (Object)e.getKey());
            ((HttpServletResponse)response).setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
        }
    }
}

