/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.waf;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bardframework.commons.waf.RequestCallCounter;

public class RequestCallCounterInMemory
implements RequestCallCounter {
    private final Map<String, Long> callCounts = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> expireTimes = new ConcurrentHashMap<String, Long>();

    @Override
    public Long increment(String key) {
        Long expireTime = this.expireTimes.get(key);
        if (null == expireTime) {
            this.callCounts.put(key, 1L);
            return 1L;
        }
        if (expireTime <= System.currentTimeMillis()) {
            this.callCounts.put(key, 1L);
            return 1L;
        }
        Long incrementedValue = this.callCounts.get(key) + 1L;
        this.callCounts.put(key, incrementedValue);
        return incrementedValue;
    }

    @Override
    public void expire(String key, int expiration, TimeUnit unit) {
        this.expireTimes.put(key, System.currentTimeMillis() + unit.toMillis(expiration));
    }
}

