/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.waf;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.bardframework.commons.waf.RequestLimitChecker;
import org.bardframework.commons.waf.exception.CallLimitExceedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class WafFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WafFilter.class);
    private final List<RequestLimitChecker> checkers;

    public WafFilter(List<RequestLimitChecker> checkers) {
        this.checkers = checkers;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            for (RequestLimitChecker checker : this.checkers) {
                if (!checker.match((HttpServletRequest)request)) continue;
                checker.checkCallLimit((HttpServletRequest)request, (HttpServletResponse)response);
            }
            chain.doFilter(request, response);
        }
        catch (CallLimitExceedException e) {
            log.warn("call limit exceed for [{}]", (Object)e.getKey());
            ((HttpServletResponse)response).setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
        }
    }
}

