/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.waf.extractor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.waf.extractor.RequestKeyDetector;

public class IpDetector
implements RequestKeyDetector {
    private final List<String> headerIpCandidates;

    public IpDetector() {
        this.headerIpCandidates = Arrays.asList("X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR");
    }

    public IpDetector(List<String> headerIpCandidates) {
        this.headerIpCandidates = headerIpCandidates;
    }

    @Override
    public String getUniqueKey(HttpServletRequest request, HttpServletResponse response) {
        for (String header : this.headerIpCandidates) {
            String headerValue = request.getHeader(header);
            if (!StringUtils.isNotEmpty((CharSequence)headerValue) || "unknown".equalsIgnoreCase(headerValue)) continue;
            return headerValue.split(",")[0];
        }
        return request.getRemoteAddr();
    }
}

