/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.waf;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bardframework.commons.waf.RequestCallCounter;
import org.bardframework.commons.waf.exception.CallLimitExceedException;
import org.bardframework.commons.waf.extractor.RequestKeyDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class RequestLimitChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestLimitChecker.class);
    private static final String PREFIX = "CALL_LIMITER_";
    private AntPathRequestMatcher requestMatcher;
    private HttpMethod httpMethod;
    private int limit;
    private int period;
    private TimeUnit periodUnit;
    private Set<String> whiteList = new HashSet<String>();
    @Autowired
    private RequestCallCounter requestCallCounter;
    @Autowired
    private RequestKeyDetector requestKeyDetector;

    public RequestLimitChecker() {
    }

    public RequestLimitChecker(String url, RequestCallCounter requestCallCounter, RequestKeyDetector requestKeyDetector, int limit, int period, TimeUnit periodUnit) {
        this.httpMethod = null;
        this.requestMatcher = new AntPathRequestMatcher(url);
        this.requestCallCounter = requestCallCounter;
        this.requestKeyDetector = requestKeyDetector;
        this.limit = limit;
        this.period = period;
        this.periodUnit = periodUnit;
    }

    public RequestLimitChecker(HttpMethod httpMethod, String url, RequestCallCounter requestCallCounter, RequestKeyDetector requestKeyDetector, int limit, int period, TimeUnit periodUnit) {
        this.httpMethod = httpMethod;
        this.requestMatcher = new AntPathRequestMatcher(url, httpMethod.name());
        this.requestCallCounter = requestCallCounter;
        this.requestKeyDetector = requestKeyDetector;
        this.limit = limit;
        this.period = period;
        this.periodUnit = periodUnit;
    }

    public void checkCallLimit(HttpServletRequest request, HttpServletResponse response) throws CallLimitExceedException {
        Object key = this.getRequestKeyDetector().getUniqueKey(request, response);
        if (null == key) {
            log.warn("can't detect unique key of request [{} {}] for checking call limit", (Object)request.getMethod(), (Object)request.getRequestURI());
            return;
        }
        if (this.getWhiteList().contains(key)) {
            log.debug("request [{} {}] with unique key[{}] not checked, unique key is in white list", new Object[]{request.getMethod(), request.getRequestURI(), key});
            return;
        }
        key = PREFIX + (String)key + (String)(null == this.getHttpMethod() ? "" : "@" + String.valueOf(this.getHttpMethod())) + "@" + this.getRequestMatcher().getPattern();
        long count = this.getRequestCallCounter().increment((String)key);
        if (count > (long)this.getLimit()) {
            throw new CallLimitExceedException((String)key);
        }
        if (count == 1L) {
            this.getRequestCallCounter().expire((String)key, this.getPeriod(), this.getPeriodUnit());
        }
    }

    public boolean match(HttpServletRequest request) {
        return this.getRequestMatcher().matches(request);
    }

    public void setWhiteList(String ... whiteList) {
        this.whiteList = new HashSet<String>(List.of(whiteList));
    }

    public void setUrl(String url) {
        this.requestMatcher = new AntPathRequestMatcher(url);
    }

    @Generated
    public AntPathRequestMatcher getRequestMatcher() {
        return this.requestMatcher;
    }

    @Generated
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public int getPeriod() {
        return this.period;
    }

    @Generated
    public TimeUnit getPeriodUnit() {
        return this.periodUnit;
    }

    @Generated
    public Set<String> getWhiteList() {
        return this.whiteList;
    }

    @Generated
    public RequestCallCounter getRequestCallCounter() {
        return this.requestCallCounter;
    }

    @Generated
    public RequestKeyDetector getRequestKeyDetector() {
        return this.requestKeyDetector;
    }

    @Generated
    public void setRequestMatcher(AntPathRequestMatcher requestMatcher) {
        this.requestMatcher = requestMatcher;
    }

    @Generated
    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Generated
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Generated
    public void setPeriod(int period) {
        this.period = period;
    }

    @Generated
    public void setPeriodUnit(TimeUnit periodUnit) {
        this.periodUnit = periodUnit;
    }

    @Generated
    public void setRequestCallCounter(RequestCallCounter requestCallCounter) {
        this.requestCallCounter = requestCallCounter;
    }

    @Generated
    public void setRequestKeyDetector(RequestKeyDetector requestKeyDetector) {
        this.requestKeyDetector = requestKeyDetector;
    }
}

