/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.waf;

import java.util.List;
import lombok.Generated;
import org.bardframework.commons.waf.RequestCallCounter;
import org.bardframework.commons.waf.RequestLimitChecker;
import org.bardframework.commons.waf.WafFilter;
import org.bardframework.commons.waf.extractor.RequestKeyDetector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConfigurationProperties(prefix="waf")
public class WafConfiguration {
    private List<RequestLimitChecker> rules;
    @Autowired
    private RequestCallCounter requestCallCounter;
    @Autowired
    private RequestKeyDetector requestKeyDetector;

    @Bean
    WafFilter wafFilter() {
        this.rules.forEach(rule -> {
            rule.setRequestCallCounter(this.requestCallCounter);
            rule.setRequestKeyDetector(this.requestKeyDetector);
        });
        return new WafFilter(this.rules);
    }

    @Generated
    public List<RequestLimitChecker> getRules() {
        return this.rules;
    }

    @Generated
    public RequestCallCounter getRequestCallCounter() {
        return this.requestCallCounter;
    }

    @Generated
    public RequestKeyDetector getRequestKeyDetector() {
        return this.requestKeyDetector;
    }

    @Generated
    public void setRules(List<RequestLimitChecker> rules) {
        this.rules = rules;
    }

    @Generated
    public void setRequestCallCounter(RequestCallCounter requestCallCounter) {
        this.requestCallCounter = requestCallCounter;
    }

    @Generated
    public void setRequestKeyDetector(RequestKeyDetector requestKeyDetector) {
        this.requestKeyDetector = requestKeyDetector;
    }
}

