/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.cookie;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bardframework.commons.utils.StringUtils;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieHandler
extends CookieGenerator {
    public Cookie get(HttpServletRequest request) {
        return WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
    }

    public String getValue(HttpServletRequest request) {
        Cookie cookie = this.get(request);
        return null == cookie ? null : cookie.getValue();
    }

    protected Cookie createCookie(String cookieValue) {
        Cookie cookie = new Cookie(this.getCookieName(), cookieValue);
        if (StringUtils.isNotBlank((CharSequence)this.getCookieDomain())) {
            cookie.setDomain(this.getCookieDomain());
        }
        cookie.setPath(this.getCookiePath());
        return cookie;
    }

    public void addCookie(HttpServletResponse response, String cookieValue, Integer maxAge) {
        Cookie cookie = this.createCookie(cookieValue);
        if (null != maxAge) {
            cookie.setMaxAge(maxAge.intValue());
        }
        if (this.isCookieSecure()) {
            cookie.setSecure(true);
        }
        if (this.isCookieHttpOnly()) {
            cookie.setHttpOnly(true);
        }
        response.addCookie(cookie);
    }
}

