/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.cors;

import java.util.List;
import javax.servlet.Filter;
import org.bardframework.commons.config.Configurator;
import org.bardframework.commons.web.cors.CorsFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;

public class CorsConfigurator
implements Configurator {
    @Value(value="${cors.mapping:#{null}}")
    private List<String> corsMapping;
    @Value(value="${cors.allowedOrigins:#{null}}")
    private List<String> corsAllowedOrigins;
    @Value(value="${cors.allowedMethods:#{null}}")
    private List<String> corsAllowedMethods;
    @Value(value="${cors.allowedHeaders:#{null}}")
    private List<String> corsAllowedHeaders;
    @Value(value="${cors.exposedHeaders:#{null}}")
    private List<String> corsExposedHeaders;
    @Value(value="${cors.allowCredentials:#{false}}")
    private boolean corsAllowCredentials;
    @Value(value="${cors.maxAgeSecond:#{30}}")
    private int corsMaxAge;
    @Value(value="${cors.enable:#{true}}")
    private boolean corsEnable;

    public void configure(HttpSecurity httpSecurity) {
        httpSecurity.addFilterBefore((Filter)this.getCorsFilter(), ChannelProcessingFilter.class);
    }

    protected List<String> getCorsMapping() {
        return this.corsMapping;
    }

    protected List<String> getCorsAllowedOrigins() {
        return this.corsAllowedOrigins;
    }

    protected List<String> getCorsAllowedMethods() {
        return this.corsAllowedMethods;
    }

    protected List<String> getCorsAllowedHeaders() {
        return this.corsAllowedHeaders;
    }

    protected List<String> getCorsExposedHeaders() {
        return this.corsExposedHeaders;
    }

    protected boolean isCorsAllowCredentials() {
        return this.corsAllowCredentials;
    }

    protected int getCorsMaxAge() {
        return this.corsMaxAge;
    }

    public boolean isCorsEnable() {
        return this.corsEnable;
    }

    protected CorsFilter getCorsFilter() {
        return new CorsFilter(this.getCorsMapping(), this.getCorsAllowedOrigins(), this.getCorsAllowedMethods(), this.getCorsAllowedHeaders(), this.getCorsExposedHeaders(), this.isCorsAllowCredentials(), this.getCorsMaxAge(), this.isCorsEnable());
    }
}

