/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.cors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.AntPathMatcher;

public class CorsFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorsFilter.class);
    private final List<RequestMatcher> corsRequestMatchers = new ArrayList<RequestMatcher>();
    private final AntPathMatcher antPathMatcher;
    private List<String> allowedOrigins;
    private List<String> allowedMethods;
    private List<String> allowedHeaders;
    private boolean allowedCredentials;
    private List<String> exposedHeaders;
    private int maxAge;

    public CorsFilter(List<String> corsMapping) {
        for (String url : corsMapping) {
            this.corsRequestMatchers.add((RequestMatcher)new AntPathRequestMatcher(url));
        }
        this.antPathMatcher = new AntPathMatcher();
        this.antPathMatcher.setTrimTokens(false);
        this.antPathMatcher.setCaseSensitive(false);
    }

    protected CorsFilter(List<String> corsMapping, List<String> allowedOrigins, List<String> allowedMethods, List<String> allowedHeaders, List<String> exposedHeaders, boolean allowedCredentials, int maxAge) {
        this(corsMapping);
        this.allowedOrigins = allowedOrigins;
        this.allowedMethods = allowedMethods;
        this.allowedHeaders = allowedHeaders;
        this.allowedCredentials = allowedCredentials;
        this.exposedHeaders = exposedHeaders;
        this.maxAge = maxAge;
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String origin = request.getHeader("Origin");
        if (StringUtils.isBlank((CharSequence)origin) || !this.needCorsCheck(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.isAllowedOrigin(origin)) {
            response.setHeader("Access-Control-Allow-Origin", origin);
        }
        if (null != this.getAllowedMethods()) {
            response.setHeader("Access-Control-Allow-Methods", String.join((CharSequence)",", this.getAllowedMethods()));
        }
        if (0 < this.getMaxAge()) {
            response.setHeader("Access-Control-Max-Age", String.valueOf(this.getMaxAge()));
        }
        if (null != this.getAllowedHeaders()) {
            response.setHeader("Access-Control-Allow-Headers", String.join((CharSequence)",", this.getAllowedHeaders()));
        }
        if (this.isAllowedCredentials()) {
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
        if (null != this.getExposedHeaders()) {
            response.addHeader("Access-Control-Expose-Headers", String.join((CharSequence)",", this.getExposedHeaders()));
        }
        if (HttpMethod.OPTIONS.matches(request.getMethod())) {
            response.setStatus(200);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean needCorsCheck(HttpServletRequest request) {
        return this.getCorsRequestMatchers().stream().anyMatch(corsRequestMatcher -> corsRequestMatcher.matches(request));
    }

    private boolean isAllowedOrigin(String origin) {
        return this.getAllowedOrigins().stream().anyMatch(allowedOrigin -> this.getAntPathMatcher().match(allowedOrigin, origin));
    }

    public List<RequestMatcher> getCorsRequestMatchers() {
        return this.corsRequestMatchers;
    }

    public List<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public List<String> getAllowedMethods() {
        return this.allowedMethods;
    }

    public List<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public boolean isAllowedCredentials() {
        return this.allowedCredentials;
    }

    public List<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }
}

