/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

public abstract class ExceptionControllerAdvice {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExceptionControllerAdvice.class);
    @Autowired
    protected MessageSource messageSource;

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public void handle(Exception ex) {
        LOGGER.error("unhandled exception occur", (Throwable)ex);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public void handle(UnsupportedOperationException ex) {
        LOGGER.error("not allowed service called", (Throwable)ex);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    @ResponseBody
    public List<String> handle(MethodArgumentNotValidException ex, Locale locale) {
        LOGGER.debug("method argument not valid, [{}]", (Object)ex.getMessage());
        return ex.getBindingResult().getAllErrors().stream().map(error -> this.messageSource.getMessage(Objects.requireNonNull(error.getCode()), error.getArguments(), locale)).collect(Collectors.toList());
    }
}

