/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web.cookie;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class CookieHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CookieHandler.class);
    private final String name;
    private final String path;
    private String domain;
    private Integer maxAge;
    private Boolean secure;
    private Boolean httpOnly;
    private Boolean hostOnly;
    private String sameSite;

    public CookieHandler(String name) {
        this(name, "/");
    }

    public CookieHandler(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public Cookie get(HttpServletRequest request) {
        return WebUtils.getCookie((HttpServletRequest)request, (String)Objects.requireNonNull(this.getName()));
    }

    public String getValue(HttpServletRequest request) {
        Cookie cookie = this.get(request);
        return null == cookie ? null : cookie.getValue();
    }

    public void addCookie(HttpServletResponse response, String cookieValue) {
        this.addCookie(response, cookieValue, this.getMaxAge());
    }

    public void addCookie(HttpServletResponse response, String cookieValue, Integer maxAge) {
        List<String> attributes = this.constructAttributes(cookieValue, maxAge);
        response.addHeader("Set-Cookie", String.join((CharSequence)";", attributes));
    }

    public void removeCookie(HttpServletResponse response) {
        List<String> attributes = this.constructAttributes("", 0);
        attributes.add("expires=Thu, Jan 01 1970 00:00:00 UTC");
        response.addHeader("Set-Cookie", String.join((CharSequence)";", attributes));
    }

    protected List<String> constructAttributes(String cookieValue, Integer maxAge) {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.add(this.getName() + "=" + cookieValue);
        if (null != maxAge) {
            attributes.add("Max-Age=" + maxAge);
        }
        if (Boolean.TRUE.equals(this.getSecure())) {
            attributes.add("Secure");
        }
        if (Boolean.TRUE.equals(this.getHttpOnly())) {
            attributes.add("HttpOnly");
        }
        if (Boolean.TRUE.equals(this.getHostOnly())) {
            attributes.add("HostOnly");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getDomain())) {
            attributes.add("Domain=" + this.getDomain());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getPath())) {
            attributes.add("Path=" + this.getPath());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getSameSite())) {
            attributes.add("SameSite=" + this.getSameSite());
        }
        return attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public Boolean getHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(Boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public Boolean getHostOnly() {
        return this.hostOnly;
    }

    public void setHostOnly(Boolean hostOnly) {
        this.hostOnly = hostOnly;
    }

    public String getSameSite() {
        return this.sameSite;
    }

    public void setSameSite(String sameSite) {
        this.sameSite = sameSite;
    }
}

