/*
 * Decompiled with CFR 0.152.
 */
package org.bardframework.commons.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bardframework.commons.web.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class WildcardReloadableMessageSource
extends ReloadableResourceBundleMessageSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(WildcardReloadableMessageSource.class);

    /*
     * WARNING - void declaration
     */
    public void addWildcardBaseNames(String ... baseNames) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        HashSet<String> finalBaseNames = new HashSet<String>();
        try {
            for (String string : baseNames) {
                String string2 = StringUtils.trimToEmpty((String)string);
                resources.addAll(List.of(ResourceUtils.getResources(string2)));
            }
            LOGGER.info("[{}] resource found from [{}] wildcard base names:\n\t{}", new Object[]{resources.size(), baseNames, resources.stream().map(Object::toString).collect(Collectors.joining("\n\t"))});
            for (Resource resource : resources) {
                void var7_21;
                String url = resource.getURL().toString();
                Object var7_13 = null;
                if (resource instanceof FileSystemResource) {
                    path = StringUtils.substringBetween((String)url, (String)"file:/", (String)".properties");
                    if (StringUtils.isNotBlank((CharSequence)path)) {
                        String string = "file:/" + path;
                    }
                } else if (resource instanceof ClassPathResource) {
                    path = StringUtils.substringBefore((String)url, (String)".properties");
                    if (StringUtils.isNotBlank((CharSequence)path)) {
                        String string = path;
                    }
                } else if (resource instanceof UrlResource) {
                    path = this.getBaseName(resource);
                    if (StringUtils.isNotBlank((CharSequence)path)) {
                        String string = "classpath:" + path;
                    }
                } else {
                    String string = url;
                }
                if (StringUtils.isNotBlank((CharSequence)var7_21)) {
                    finalBaseNames.add(this.processBasename((String)var7_21));
                    continue;
                }
                LOGGER.error("can't detect base name from i18n file [{}]", (Object)resource);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        LOGGER.info("final base names from wildcard are:\n\t{}", (Object)String.join((CharSequence)"\n\t", finalBaseNames));
        super.addBasenames((String[])finalBaseNames.toArray(String[]::new));
    }

    public Properties getAllProperties(Locale locale) {
        this.clearCacheIncludingAncestors();
        ReloadableResourceBundleMessageSource.PropertiesHolder propertiesHolder = this.getMergedProperties(locale);
        return propertiesHolder.getProperties();
    }

    private String processBasename(String baseName) {
        String prefix = StringUtils.substringBeforeLast((String)baseName, (String)"/");
        String name = StringUtils.substringAfterLast((String)baseName, (String)"/");
        while ((name = StringUtils.substringBeforeLast((String)name, (String)"_")).contains("_")) {
        }
        return prefix + "/" + name;
    }

    private String getBaseName(Resource resource) throws IOException {
        String baseName = StringUtils.substringAfterLast((String)resource.getURL().toString(), (String)".jar!/");
        if (baseName.contains("classes!/")) {
            baseName = StringUtils.substringAfterLast((String)baseName, (String)"classes!/");
        }
        if (baseName.contains("classes/")) {
            baseName = StringUtils.substringAfterLast((String)baseName, (String)"classes/");
        }
        return StringUtils.substringBefore((String)baseName, (String)".properties");
    }
}

